/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.player;

import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerLifecycleManager;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.hook.AudioOutputHook;
import com.sedmelluq.discord.lavaplayer.player.hook.AudioOutputHookFactory;
import com.sedmelluq.discord.lavaplayer.remote.RemoteAudioTrackExecutor;
import com.sedmelluq.discord.lavaplayer.remote.RemoteNodeManager;
import com.sedmelluq.discord.lavaplayer.remote.RemoteNodeRegistry;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.DaemonThreadFactory;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.ExecutorTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.GarbageCollectionMonitor;
import com.sedmelluq.discord.lavaplayer.tools.OrderedExecutor;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageInput;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageOutput;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DecodedTrackHolder;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.TrackStateListener;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAudioPlayerManager
implements AudioPlayerManager {
    private static final int DEFAULT_FRAME_BUFFER_DURATION = (int)TimeUnit.SECONDS.toMillis(5L);
    private static final int DEFAULT_CLEANUP_THRESHOLD = (int)TimeUnit.MINUTES.toMillis(1L);
    private static final int MAXIMUM_LOAD_REDIRECTS = 5;
    private static final int DEFAULT_LOADER_POOL_SIZE = 10;
    private static final int LOADER_QUEUE_CAPACITY = 5000;
    private static final Logger log = LoggerFactory.getLogger(DefaultAudioPlayerManager.class);
    private final List<AudioSourceManager> sourceManagers = new ArrayList<AudioSourceManager>();
    private final ExecutorService trackPlaybackExecutorService = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("playback"));
    private final ThreadPoolExecutor trackInfoExecutorService = ExecutorTools.createEagerlyScalingExecutor(1, 10, TimeUnit.SECONDS.toMillis(30L), 5000, new DaemonThreadFactory("info-loader"));
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("manager"));
    private final OrderedExecutor orderedInfoExecutor = new OrderedExecutor(this.trackInfoExecutorService);
    private volatile long trackStuckThreshold = TimeUnit.MILLISECONDS.toNanos(10000L);
    private volatile AudioConfiguration configuration = new AudioConfiguration();
    private final AtomicLong cleanupThreshold = new AtomicLong(DEFAULT_CLEANUP_THRESHOLD);
    private volatile int frameBufferDuration = DEFAULT_FRAME_BUFFER_DURATION;
    private volatile boolean useSeekGhosting = true;
    private volatile AudioOutputHookFactory outputHookFactory = null;
    private final RemoteNodeManager remoteNodeManager = new RemoteNodeManager(this);
    private final GarbageCollectionMonitor garbageCollectionMonitor = new GarbageCollectionMonitor(this.scheduledExecutorService);
    private final AudioPlayerLifecycleManager lifecycleManager = new AudioPlayerLifecycleManager(this.scheduledExecutorService, this.cleanupThreshold);

    public DefaultAudioPlayerManager() {
        this.lifecycleManager.initialise();
    }

    @Override
    public void shutdown() {
        this.remoteNodeManager.shutdown();
        this.garbageCollectionMonitor.disable();
        this.lifecycleManager.shutdown();
        for (AudioSourceManager sourceManager : this.sourceManagers) {
            sourceManager.shutdown();
        }
        ExecutorTools.shutdownExecutor(this.trackPlaybackExecutorService, "track playback");
        ExecutorTools.shutdownExecutor(this.trackInfoExecutorService, "track info");
        ExecutorTools.shutdownExecutor(this.scheduledExecutorService, "scheduled operations");
    }

    @Override
    public void setOutputHookFactory(AudioOutputHookFactory outputHookFactory) {
        this.outputHookFactory = outputHookFactory;
    }

    @Override
    public void useRemoteNodes(String ... nodeAddresses) {
        if (nodeAddresses.length > 0) {
            this.remoteNodeManager.initialise(Arrays.asList(nodeAddresses));
        } else {
            this.remoteNodeManager.shutdown();
        }
    }

    @Override
    public void enableGcMonitoring() {
        this.garbageCollectionMonitor.enable();
    }

    @Override
    public void registerSourceManager(AudioSourceManager sourceManager) {
        this.sourceManagers.add(sourceManager);
    }

    @Override
    public <T extends AudioSourceManager> T source(Class<T> klass) {
        for (AudioSourceManager sourceManager : this.sourceManagers) {
            if (!klass.isAssignableFrom(sourceManager.getClass())) continue;
            return (T)sourceManager;
        }
        return null;
    }

    @Override
    public Future<Void> loadItem(String identifier, AudioLoadResultHandler resultHandler) {
        try {
            return this.trackInfoExecutorService.submit(this.createItemLoader(identifier, resultHandler));
        }
        catch (RejectedExecutionException e) {
            return this.handleLoadRejected(identifier, resultHandler, e);
        }
    }

    @Override
    public Future<Void> loadItemOrdered(Object orderingKey, String identifier, AudioLoadResultHandler resultHandler) {
        try {
            return this.orderedInfoExecutor.submit(orderingKey, this.createItemLoader(identifier, resultHandler));
        }
        catch (RejectedExecutionException e) {
            return this.handleLoadRejected(identifier, resultHandler, e);
        }
    }

    private Future<Void> handleLoadRejected(String identifier, AudioLoadResultHandler resultHandler, RejectedExecutionException e) {
        FriendlyException exception = new FriendlyException("Cannot queue loading a track, queue is full.", FriendlyException.Severity.SUSPICIOUS, e);
        ExceptionTools.log(log, exception, "queueing item " + identifier);
        resultHandler.loadFailed(exception);
        return ExecutorTools.COMPLETED_VOID;
    }

    private Callable<Void> createItemLoader(String identifier, AudioLoadResultHandler resultHandler) {
        return () -> {
            try {
                if (!this.checkSourcesForItem(new AudioReference(identifier, null), resultHandler)) {
                    log.debug("No matches for track with identifier {}.", (Object)identifier);
                    resultHandler.noMatches();
                }
            }
            catch (Throwable throwable) {
                FriendlyException exception = ExceptionTools.wrapUnfriendlyExceptions("Something went wrong when looking up the track", FriendlyException.Severity.FAULT, throwable);
                ExceptionTools.log(log, exception, "loading item " + identifier);
                resultHandler.loadFailed(exception);
                ExceptionTools.rethrowErrors(throwable);
            }
            return null;
        };
    }

    @Override
    public void encodeTrack(MessageOutput stream, AudioTrack track) throws IOException {
        DataOutput output = stream.startMessage();
        AudioTrackInfo trackInfo = track.getInfo();
        output.writeUTF(trackInfo.title);
        output.writeUTF(trackInfo.author);
        output.writeLong(trackInfo.length);
        output.writeUTF(trackInfo.identifier);
        output.writeBoolean(trackInfo.isStream);
        this.encodeTrackDetails(track, output);
        output.writeLong(track.getPosition());
        stream.commitMessage();
    }

    @Override
    public DecodedTrackHolder decodeTrack(MessageInput stream) throws IOException {
        DataInput input = stream.nextMessage();
        if (input == null) {
            return null;
        }
        AudioTrackInfo trackInfo = new AudioTrackInfo(input.readUTF(), input.readUTF(), input.readLong(), input.readUTF(), input.readBoolean());
        AudioTrack track = this.decodeTrackDetails(trackInfo, input);
        long position = input.readLong();
        if (track != null) {
            track.setPosition(position);
        }
        stream.skipRemainingBytes();
        return new DecodedTrackHolder(track);
    }

    public byte[] encodeTrackDetails(AudioTrack track) {
        try {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteOutput);
            this.encodeTrackDetails(track, output);
            return byteOutput.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void encodeTrackDetails(AudioTrack track, DataOutput output) throws IOException {
        AudioSourceManager sourceManager = track.getSourceManager();
        output.writeUTF(sourceManager.getSourceName());
        sourceManager.encodeTrack(track, output);
    }

    public AudioTrack decodeTrackDetails(AudioTrackInfo trackInfo, byte[] buffer) {
        try {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(buffer));
            return this.decodeTrackDetails(trackInfo, input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private AudioTrack decodeTrackDetails(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        String sourceName = input.readUTF();
        for (AudioSourceManager sourceManager : this.sourceManagers) {
            if (!sourceName.equals(sourceManager.getSourceName())) continue;
            return sourceManager.decodeTrack(trackInfo, input);
        }
        return null;
    }

    public void executeTrack(TrackStateListener listener, InternalAudioTrack track, AudioConfiguration configuration, AtomicInteger volumeLevel) {
        AudioTrackExecutor executor = this.createExecutorForTrack(track, configuration, volumeLevel);
        track.assignExecutor(executor, true);
        this.trackPlaybackExecutorService.execute(() -> executor.execute(listener));
    }

    private AudioTrackExecutor createExecutorForTrack(InternalAudioTrack track, AudioConfiguration configuration, AtomicInteger volumeLevel) {
        AudioSourceManager sourceManager = track.getSourceManager();
        if (this.remoteNodeManager.isEnabled() && sourceManager != null && sourceManager.isTrackEncodable(track)) {
            return new RemoteAudioTrackExecutor(track, configuration, this.remoteNodeManager, volumeLevel);
        }
        AudioTrackExecutor customExecutor = track.createLocalExecutor(this);
        if (customExecutor != null) {
            return customExecutor;
        }
        return new LocalAudioTrackExecutor(track, configuration, volumeLevel, this.useSeekGhosting, this.frameBufferDuration);
    }

    @Override
    public AudioConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isUsingSeekGhosting() {
        return this.useSeekGhosting;
    }

    @Override
    public void setUseSeekGhosting(boolean useSeekGhosting) {
        this.useSeekGhosting = useSeekGhosting;
    }

    @Override
    public int getFrameBufferDuration() {
        return this.frameBufferDuration;
    }

    @Override
    public void setFrameBufferDuration(int frameBufferDuration) {
        this.frameBufferDuration = Math.max(200, frameBufferDuration);
    }

    @Override
    public void setTrackStuckThreshold(long trackStuckThreshold) {
        this.trackStuckThreshold = TimeUnit.MILLISECONDS.toNanos(trackStuckThreshold);
    }

    public long getTrackStuckThresholdNanos() {
        return this.trackStuckThreshold;
    }

    @Override
    public void setPlayerCleanupThreshold(long cleanupThreshold) {
        this.cleanupThreshold.set(cleanupThreshold);
    }

    @Override
    public void setItemLoaderThreadPoolSize(int poolSize) {
        this.trackInfoExecutorService.setMaximumPoolSize(poolSize);
    }

    private boolean checkSourcesForItem(AudioReference reference, AudioLoadResultHandler resultHandler) {
        AudioReference currentReference = reference;
        for (int redirects = 0; redirects < 5 && currentReference.identifier != null; ++redirects) {
            AudioItem item = this.checkSourcesForItemOnce(currentReference, resultHandler);
            if (item == null) {
                return false;
            }
            if (!(item instanceof AudioReference)) {
                return true;
            }
            currentReference = (AudioReference)item;
        }
        return false;
    }

    private AudioItem checkSourcesForItemOnce(AudioReference reference, AudioLoadResultHandler resultHandler) {
        for (AudioSourceManager sourceManager : this.sourceManagers) {
            AudioItem item = sourceManager.loadItem(this, reference);
            if (item == null) continue;
            if (item instanceof AudioTrack) {
                log.debug("Loaded a track with identifier {} using {}.", (Object)reference.identifier, (Object)sourceManager.getClass().getSimpleName());
                resultHandler.trackLoaded((AudioTrack)item);
            } else if (item instanceof AudioPlaylist) {
                log.debug("Loaded a playlist with identifier {} using {}.", (Object)reference.identifier, (Object)sourceManager.getClass().getSimpleName());
                resultHandler.playlistLoaded((AudioPlaylist)item);
            }
            return item;
        }
        return null;
    }

    public ExecutorService getExecutor() {
        return this.trackPlaybackExecutorService;
    }

    @Override
    public AudioPlayer createPlayer() {
        AudioOutputHook outputHook = this.outputHookFactory != null ? this.outputHookFactory.createOutputHook() : null;
        AudioPlayer player = new AudioPlayer(this, outputHook);
        player.addListener(this.lifecycleManager);
        if (this.remoteNodeManager.isEnabled()) {
            player.addListener(this.remoteNodeManager);
        }
        return player;
    }

    @Override
    public RemoteNodeRegistry getRemoteNodeRegistry() {
        return this.remoteNodeManager;
    }
}

