/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.player;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.StandardAudioDataFormats;

public class AudioConfiguration {
    public static final int OPUS_QUALITY_MAX = 10;
    private volatile ResamplingQuality resamplingQuality = ResamplingQuality.LOW;
    private volatile int opusEncodingQuality = 10;
    private volatile AudioDataFormat outputFormat = StandardAudioDataFormats.DISCORD_OPUS;

    public ResamplingQuality getResamplingQuality() {
        return this.resamplingQuality;
    }

    public void setResamplingQuality(ResamplingQuality resamplingQuality) {
        this.resamplingQuality = resamplingQuality;
    }

    public int getOpusEncodingQuality() {
        return this.opusEncodingQuality;
    }

    public void setOpusEncodingQuality(int opusEncodingQuality) {
        this.opusEncodingQuality = Math.max(0, Math.min(opusEncodingQuality, 10));
    }

    public AudioDataFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(AudioDataFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public AudioConfiguration copy() {
        AudioConfiguration copy = new AudioConfiguration();
        copy.setResamplingQuality(this.resamplingQuality);
        copy.setOpusEncodingQuality(this.opusEncodingQuality);
        copy.setOutputFormat(this.outputFormat);
        return copy;
    }

    public static enum ResamplingQuality {
        HIGH,
        MEDIUM,
        LOW;

    }
}

