/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.AudioPostProcessor;
import com.sedmelluq.discord.lavaplayer.filter.BufferingPostProcessor;
import com.sedmelluq.discord.lavaplayer.filter.ChannelCountPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.FinalPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.ResamplingPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.ShortToFloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.SplitShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.volume.VolumePostProcessor;
import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.OpusChunkEncoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.PcmChunkEncoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.util.Arrays;
import java.util.Collection;

public class FilterChainBuilder {
    public static ShortPcmAudioFilter forShortPcm(AudioProcessingContext context, int channels, int sampleRate, boolean noPartialFrames) {
        FinalPcmAudioFilter end = new FinalPcmAudioFilter(context, FilterChainBuilder.createPostProcessors(context));
        AudioDataFormat format = context.outputFormat;
        ShortPcmAudioFilter filter = sampleRate != format.sampleRate ? new ShortToFloatPcmAudioFilter(format.channelCount, new ResamplingPcmAudioFilter(context.configuration, format.channelCount, end, sampleRate, format.sampleRate)) : end;
        if (channels != format.channelCount || !noPartialFrames) {
            filter = new ChannelCountPcmAudioFilter(channels, format.channelCount, filter);
        }
        return filter;
    }

    public static SplitShortPcmAudioFilter forSplitShortPcm(AudioProcessingContext context, int frequency) {
        FinalPcmAudioFilter opusEncoder = new FinalPcmAudioFilter(context, FilterChainBuilder.createPostProcessors(context));
        AudioDataFormat format = context.outputFormat;
        ShortPcmAudioFilter filter = frequency != format.sampleRate ? new ShortToFloatPcmAudioFilter(format.channelCount, new ResamplingPcmAudioFilter(context.configuration, format.channelCount, opusEncoder, frequency, format.sampleRate)) : opusEncoder;
        return filter;
    }

    public static FloatPcmAudioFilter forFloatPcm(AudioProcessingContext context, int channels, int sampleRate) {
        FloatPcmAudioFilter filter = new FinalPcmAudioFilter(context, FilterChainBuilder.createPostProcessors(context));
        if (sampleRate != context.outputFormat.sampleRate) {
            filter = new ResamplingPcmAudioFilter(context.configuration, channels, filter, sampleRate, context.outputFormat.sampleRate);
        }
        return filter;
    }

    public static boolean isProcessingRequired(AudioProcessingContext context, AudioDataFormat inputFormat) {
        return !context.outputFormat.equals(inputFormat) || context.volumeLevel.get() != 100;
    }

    private static Collection<AudioPostProcessor> createPostProcessors(AudioProcessingContext context) {
        AudioChunkEncoder chunkEncoder = context.outputFormat.codec == AudioDataFormat.Codec.OPUS ? new OpusChunkEncoder(context.configuration, context.outputFormat) : new PcmChunkEncoder(context.outputFormat);
        return Arrays.asList(new VolumePostProcessor(context), new BufferingPostProcessor(context, chunkEncoder));
    }
}

