/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.playlists;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainPlaylistContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(PlainPlaylistContainerProbe.class);
    private static final Pattern linkPattern = Pattern.compile("^(?:https?|icy)://.*");

    @Override
    public String getName() {
        return "plain";
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.matchNextBytesAsRegex(inputStream, 1000, linkPattern, StandardCharsets.UTF_8)) {
            return null;
        }
        log.debug("Track {} is a plain playlist file.", (Object)reference.identifier);
        return this.loadFromLines(DataFormatTools.streamToLines(inputStream, StandardCharsets.UTF_8));
    }

    private MediaContainerDetectionResult loadFromLines(String[] lines) {
        for (String line : lines) {
            Matcher matcher = linkPattern.matcher(line);
            if (!matcher.matches()) continue;
            return new MediaContainerDetectionResult((MediaContainerProbe)this, new AudioReference(matcher.group(0), null));
        }
        return new MediaContainerDetectionResult((MediaContainerProbe)this, "The playlist file contains no links.");
    }

    @Override
    public AudioTrack createTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        throw new UnsupportedOperationException();
    }
}

