/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;

public abstract class OrderAction<T, M extends OrderAction>
extends RestAction<Void> {
    protected final JDA api;
    protected final List<T> orderList;
    protected final boolean ascendingOrder;
    protected int selectedPosition = -1;

    public OrderAction(JDA api, Route.CompiledRoute route) {
        this(api, true, route);
    }

    public OrderAction(JDA api, boolean ascendingOrder, Route.CompiledRoute route) {
        super(api, route, null);
        this.api = api;
        this.orderList = new ArrayList<T>();
        this.ascendingOrder = ascendingOrder;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    public List<T> getCurrentOrder() {
        return Collections.unmodifiableList(this.orderList);
    }

    public M selectPosition(int selectedPosition) {
        Args.notNegative(selectedPosition, "Provided selectedPosition");
        Args.check(selectedPosition < this.orderList.size(), "Provided selectedPosition is too big and is out of bounds. selectedPosition: " + selectedPosition);
        this.selectedPosition = selectedPosition;
        return (M)this;
    }

    public M selectPosition(T selectedEntity) {
        Args.notNull(selectedEntity, "Channel");
        this.validateInput(selectedEntity);
        return this.selectPosition((T)this.orderList.indexOf(selectedEntity));
    }

    public int getSelectedPosition() {
        return this.selectedPosition;
    }

    public T getSelectedEntity() {
        if (this.selectedPosition == -1) {
            throw new IllegalStateException("No position has been selected yet");
        }
        return this.orderList.get(this.selectedPosition);
    }

    public M moveUp(int amount) {
        Args.notNegative(amount, "Provided amount");
        if (this.selectedPosition == -1) {
            throw new IllegalStateException("Cannot move until an item has been selected. Use #selectPosition first.");
        }
        if (this.ascendingOrder) {
            Args.check(this.selectedPosition - amount >= 0, "Amount provided to move up is too large and would be out of bounds.Selected position: " + this.selectedPosition + " Amount: " + amount + " Largest Position: " + this.orderList.size());
        } else {
            Args.check(this.selectedPosition + amount < this.orderList.size(), "Amount provided to move up is too large and would be out of bounds.Selected position: " + this.selectedPosition + " Amount: " + amount + " Largest Position: " + this.orderList.size());
        }
        if (this.ascendingOrder) {
            return this.moveTo(this.selectedPosition - amount);
        }
        return this.moveTo(this.selectedPosition + amount);
    }

    public M moveDown(int amount) {
        Args.notNegative(amount, "Provided amount");
        if (this.selectedPosition == -1) {
            throw new IllegalStateException("Cannot move until an item has been selected. Use #selectPosition first.");
        }
        if (this.ascendingOrder) {
            Args.check(this.selectedPosition + amount < this.orderList.size(), "Amount provided to move down is too large and would be out of bounds.Selected position: " + this.selectedPosition + " Amount: " + amount + " Largest Position: " + this.orderList.size());
        } else {
            Args.check(this.selectedPosition - amount >= this.orderList.size(), "Amount provided to move down is too large and would be out of bounds.Selected position: " + this.selectedPosition + " Amount: " + amount + " Largest Position: " + this.orderList.size());
        }
        if (this.ascendingOrder) {
            return this.moveTo(this.selectedPosition + amount);
        }
        return this.moveTo(this.selectedPosition - amount);
    }

    public M moveTo(int position) {
        Args.notNegative(position, "Provided position");
        Args.check(position < this.orderList.size(), "Provided position is too big and is out of bounds.");
        T selectedItem = this.orderList.remove(this.selectedPosition);
        this.orderList.add(position, selectedItem);
        return (M)this;
    }

    public M swapPosition(int swapPosition) {
        Args.notNegative(swapPosition, "Provided swapPosition");
        Args.check(swapPosition < this.orderList.size(), "Provided swapPosition is too big and is out of bounds. swapPosition: " + swapPosition);
        T selectedItem = this.orderList.get(this.selectedPosition);
        T swapItem = this.orderList.get(swapPosition);
        this.orderList.set(swapPosition, selectedItem);
        this.orderList.set(this.selectedPosition, swapItem);
        return (M)this;
    }

    public M swapPosition(T swapEntity) {
        Args.notNull(swapEntity, "Provided swapEntity");
        this.validateInput(swapEntity);
        return this.swapPosition((T)this.orderList.indexOf(swapEntity));
    }

    public M reverseOrder() {
        Collections.reverse(this.orderList);
        return (M)this;
    }

    public M shuffleOrder() {
        Collections.shuffle(this.orderList);
        return (M)this;
    }

    public M sortOrder(Comparator<T> comparator) {
        Args.notNull(comparator, "Provided comparator");
        this.orderList.sort(comparator);
        return (M)this;
    }

    @Override
    protected void handleResponse(Response response, Request request) {
        if (response.isOk()) {
            request.onSuccess(null);
        } else {
            request.onFailure(response);
        }
    }

    @Override
    protected abstract void finalizeData();

    protected abstract void validateInput(T var1);
}

