/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers.impl;

import com.sun.jna.Platform;
import java.io.IOException;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.audio.AudioConnection;
import net.dv8tion.jda.core.audio.AudioReceiveHandler;
import net.dv8tion.jda.core.audio.AudioSendHandler;
import net.dv8tion.jda.core.audio.hooks.ConnectionListener;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.audio.hooks.ListenerProxy;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.GuildUnavailableException;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.utils.NativeUtil;
import org.json.JSONObject;

public class AudioManagerImpl
implements AudioManager {
    public static boolean AUDIO_SUPPORTED;
    public static String OPUS_LIB_NAME;
    protected static boolean initialized;
    protected final JDAImpl api;
    protected final Guild guild;
    protected AudioConnection audioConnection = null;
    protected VoiceChannel queuedAudioConnection = null;
    protected AudioSendHandler sendHandler;
    protected AudioReceiveHandler receiveHandler;
    protected ListenerProxy connectionListener = new ListenerProxy();
    protected long queueTimeout = 100L;
    protected boolean shouldReconnect = true;
    protected boolean selfMuted = false;
    protected boolean selfDeafened = false;
    protected long timeout = 10000L;

    public AudioManagerImpl(Guild guild) {
        this.guild = guild;
        this.api = (JDAImpl)guild.getJDA();
        AudioManagerImpl.init();
    }

    @Override
    public void openAudioConnection(VoiceChannel channel) {
        Args.notNull(channel, "Provided VoiceChannel");
        if (!AUDIO_SUPPORTED) {
            throw new UnsupportedOperationException("Sorry! Audio is disabled due to an internal JDA error! Contact Dev!");
        }
        if (!this.guild.equals(channel.getGuild())) {
            throw new IllegalArgumentException("The provided VoiceChannel is not a part of the Guild that this AudioManager handles.Please provide a VoiceChannel from the proper Guild");
        }
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException("Cannot open an Audio Connection with an unavailable guild. Please wait until this Guild is available to open a connection.");
        }
        Member self = this.guild.getSelfMember();
        if (!self.hasPermission((Channel)channel, Permission.VOICE_CONNECT)) {
            throw new PermissionException(Permission.VOICE_CONNECT);
        }
        int userLimit = channel.getUserLimit();
        if (!self.hasPermission((Channel)channel, Permission.MANAGE_CHANNEL) && userLimit > 0 && userLimit <= channel.getMembers().size()) {
            throw new PermissionException(Permission.MANAGE_CHANNEL, "Unable to connect to VoiceChannel due to userlimit! Requires permission MANAGE_CHANNEL to bypass");
        }
        if (this.audioConnection == null) {
            this.queuedAudioConnection = channel;
            this.api.getClient().queueAudioConnect(channel);
        } else {
            if (channel.equals(this.audioConnection.getChannel())) {
                return;
            }
            this.api.getClient().queueAudioConnect(channel);
            this.audioConnection.setChannel(channel);
        }
    }

    @Override
    public void closeAudioConnection() {
        this.closeAudioConnection(ConnectionStatus.NOT_CONNECTED);
    }

    public void closeAudioConnection(ConnectionStatus reason) {
        this.api.getClient().getQueuedAudioConnectionMap().remove(this.guild.getId());
        this.queuedAudioConnection = null;
        if (this.audioConnection == null) {
            return;
        }
        this.audioConnection.close(reason);
        this.audioConnection = null;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public boolean isAttemptingToConnect() {
        return this.queuedAudioConnection != null;
    }

    @Override
    public VoiceChannel getQueuedAudioConnection() {
        return this.queuedAudioConnection;
    }

    @Override
    public VoiceChannel getConnectedChannel() {
        return this.audioConnection == null ? null : this.audioConnection.getChannel();
    }

    @Override
    public boolean isConnected() {
        return this.audioConnection != null;
    }

    @Override
    public void setConnectTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getConnectTimeout() {
        return this.timeout;
    }

    @Override
    public void setSendingHandler(AudioSendHandler handler) {
        this.sendHandler = handler;
        if (this.audioConnection != null) {
            this.audioConnection.setSendingHandler(handler);
        }
    }

    @Override
    public AudioSendHandler getSendingHandler() {
        return this.sendHandler;
    }

    @Override
    public void setReceivingHandler(AudioReceiveHandler handler) {
        this.receiveHandler = handler;
        if (this.audioConnection != null) {
            this.audioConnection.setReceivingHandler(handler);
        }
    }

    @Override
    public AudioReceiveHandler getReceiveHandler() {
        return this.receiveHandler;
    }

    @Override
    public void setConnectionListener(ConnectionListener listener) {
        this.connectionListener.setListener(listener);
    }

    @Override
    public ConnectionListener getConnectionListener() {
        return this.connectionListener.getListener();
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        if (this.audioConnection != null) {
            return this.audioConnection.getWebSocket().getConnectionStatus();
        }
        return ConnectionStatus.NOT_CONNECTED;
    }

    @Override
    public void setAutoReconnect(boolean shouldReconnect) {
        this.shouldReconnect = shouldReconnect;
        if (this.audioConnection != null) {
            this.audioConnection.getWebSocket().setAutoReconnect(shouldReconnect);
        }
    }

    @Override
    public boolean isAutoReconnect() {
        return this.shouldReconnect;
    }

    @Override
    public void setSelfMuted(boolean muted) {
        if (this.selfMuted != muted) {
            this.selfMuted = muted;
            this.updateVoiceState();
        }
    }

    @Override
    public boolean isSelfMuted() {
        return this.selfMuted;
    }

    @Override
    public void setSelfDeafened(boolean deafened) {
        if (this.selfDeafened != deafened) {
            this.selfDeafened = deafened;
            this.updateVoiceState();
        }
    }

    @Override
    public boolean isSelfDeafened() {
        return this.selfDeafened;
    }

    public ConnectionListener getListenerProxy() {
        return this.connectionListener;
    }

    public void setAudioConnection(AudioConnection audioConnection) {
        this.audioConnection = audioConnection;
        if (audioConnection == null) {
            return;
        }
        this.queuedAudioConnection = null;
        audioConnection.setSendingHandler(this.sendHandler);
        audioConnection.setReceivingHandler(this.receiveHandler);
        audioConnection.setQueueTimeout(this.queueTimeout);
        audioConnection.ready(this.timeout);
    }

    public void prepareForRegionChange() {
        VoiceChannel queuedChannel = this.audioConnection.getChannel();
        this.closeAudioConnection(ConnectionStatus.AUDIO_REGION_CHANGE);
        this.queuedAudioConnection = queuedChannel;
    }

    public void setQueuedAudioConnection(VoiceChannel channel) {
        this.queuedAudioConnection = channel;
    }

    public void setConnectedChannel(VoiceChannel channel) {
        if (this.audioConnection != null) {
            this.audioConnection.setChannel(channel);
        }
    }

    public void setQueueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
        if (this.audioConnection != null) {
            this.audioConnection.setQueueTimeout(queueTimeout);
        }
    }

    protected void updateVoiceState() {
        if (this.isConnected() || this.isAttemptingToConnect()) {
            VoiceChannel channel = this.isConnected() ? this.getConnectedChannel() : this.getQueuedAudioConnection();
            JSONObject voiceStateChange = new JSONObject().put("op", 4).put("d", new JSONObject().put("guild_id", this.guild.getId()).put("channel_id", channel.getId()).put("self_mute", this.isSelfMuted()).put("self_deaf", this.isSelfDeafened()));
            this.api.getClient().send(voiceStateChange.toString());
        }
    }

    public static synchronized boolean init() {
        if (initialized) {
            return AUDIO_SUPPORTED;
        }
        initialized = true;
        String nativesRoot = null;
        try {
            nativesRoot = "/natives/" + Platform.RESOURCE_PREFIX + "/%s";
            if (nativesRoot.contains("darwin")) {
                nativesRoot = nativesRoot + ".dylib";
            } else if (nativesRoot.contains("win")) {
                nativesRoot = nativesRoot + ".dll";
            } else if (nativesRoot.contains("linux")) {
                nativesRoot = nativesRoot + ".so";
            } else {
                throw new UnsupportedOperationException();
            }
            NativeUtil.loadLibraryFromJar(String.format(nativesRoot, "libopus"));
            OPUS_LIB_NAME = nativesRoot != null ? String.format(nativesRoot, "libopus") : null;
        }
        catch (Throwable e) {
            try {
                if (e instanceof UnsupportedOperationException) {
                    LOG.fatal("Sorry, JDA's audio system doesn't support this system.\nSupported Systems: Windows(x86, x64), Mac(x86, x64) and Linux(x86, x64)\nOperating system: " + Platform.RESOURCE_PREFIX);
                } else if (e instanceof IOException) {
                    LOG.fatal("There was an IO Exception when setting up the temp files for audio.");
                    LOG.log(e);
                } else if (e instanceof UnsatisfiedLinkError) {
                    LOG.fatal("JDA encountered a problem when attempting to load the Native libraries. Contact a DEV.");
                    LOG.log(e);
                } else {
                    LOG.fatal("An unknown error occurred while attempting to setup JDA's audio system!");
                    LOG.log(e);
                }
                nativesRoot = null;
                OPUS_LIB_NAME = nativesRoot != null ? String.format(nativesRoot, "libopus") : null;
            }
            catch (Throwable throwable) {
                OPUS_LIB_NAME = nativesRoot != null ? String.format(nativesRoot, "libopus") : null;
                boolean bl = AUDIO_SUPPORTED = nativesRoot != null;
                if (AUDIO_SUPPORTED) {
                    LOG.info("Audio System successfully setup!");
                } else {
                    LOG.info("Audio System encountered problems while loading, thus, is disabled.");
                }
                return AUDIO_SUPPORTED;
            }
            boolean bl = AUDIO_SUPPORTED = nativesRoot != null;
            if (AUDIO_SUPPORTED) {
                LOG.info("Audio System successfully setup!");
            } else {
                LOG.info("Audio System encountered problems while loading, thus, is disabled.");
            }
            return AUDIO_SUPPORTED;
        }
        boolean bl = AUDIO_SUPPORTED = nativesRoot != null;
        if (AUDIO_SUPPORTED) {
            LOG.info("Audio System successfully setup!");
        } else {
            LOG.info("Audio System encountered problems while loading, thus, is disabled.");
        }
        return AUDIO_SUPPORTED;
    }

    static {
        initialized = false;
    }
}

