/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.role.RoleCreateEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.GuildLock;
import org.json.JSONObject;

public class GuildRoleCreateHandler
extends SocketHandler {
    public GuildRoleCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String guildId = content.getString("guild_id");
        if (GuildLock.get(this.api).isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
        if (guild == null) {
            EventCache.get(this.api).cache(EventCache.Type.GUILD, guildId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("GUILD_ROLE_CREATE was received for a Guild that is not yet cached: " + content);
            return null;
        }
        Role newRole = EntityBuilder.get(this.api).createRole(content.getJSONObject("role"), guild.getId());
        this.api.getEventManager().handle(new RoleCreateEvent(this.api, this.responseNumber, newRole));
        EventCache.get(this.api).playbackCache(EventCache.Type.ROLE, newRole.getId());
        return null;
    }
}

