/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.IMentionable;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.managers.PermOverrideManager;
import net.dv8tion.jda.core.managers.PermOverrideManagerUpdatable;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;

public class PermissionOverrideImpl
implements PermissionOverride {
    protected volatile PermOverrideManager manager;
    protected volatile PermOverrideManagerUpdatable managerUpdatable;
    protected volatile Object mngLock = new Object();
    private final Member member;
    private final Role role;
    private final Channel channel;
    private long allow;
    private long deny;

    public PermissionOverrideImpl(Channel channel, Member member, Role role) {
        this.channel = channel;
        this.member = member;
        this.role = role;
    }

    @Override
    public long getAllowedRaw() {
        return this.allow;
    }

    @Override
    public long getInheritRaw() {
        return (this.allow | this.deny) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long getDeniedRaw() {
        return this.deny;
    }

    @Override
    public List<Permission> getAllowed() {
        return Collections.unmodifiableList(Permission.getPermissions(this.allow));
    }

    @Override
    public List<Permission> getInherit() {
        return Collections.unmodifiableList(Permission.getPermissions(this.getInheritRaw()));
    }

    @Override
    public List<Permission> getDenied() {
        return Collections.unmodifiableList(Permission.getPermissions(this.deny));
    }

    @Override
    public JDA getJDA() {
        return this.channel.getJDA();
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public Guild getGuild() {
        return this.channel.getGuild();
    }

    @Override
    public boolean isMemberOverride() {
        return this.getMember() != null;
    }

    @Override
    public boolean isRoleOverride() {
        return this.getRole() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermOverrideManager getManager() {
        PermOverrideManager mng = this.manager;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.manager;
                if (mng == null) {
                    mng = this.manager = new PermOverrideManager(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermOverrideManagerUpdatable getManagerUpdatable() {
        PermOverrideManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.managerUpdatable;
                if (mng == null) {
                    mng = this.managerUpdatable = new PermOverrideManagerUpdatable(this);
                }
            }
        }
        return mng;
    }

    @Override
    public RestAction<Void> delete() {
        if (!this.channel.getGuild().getSelfMember().hasPermission(this.channel, Permission.MANAGE_PERMISSIONS)) {
            throw new PermissionException(Permission.MANAGE_PERMISSIONS);
        }
        String targetId = this.isRoleOverride() ? this.role.getId() : this.member.getUser().getId();
        Route.CompiledRoute route = Route.Channels.DELETE_PERM_OVERRIDE.compile(this.channel.getId(), targetId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public PermissionOverrideImpl setAllow(long allow) {
        this.allow = allow;
        return this;
    }

    public PermissionOverrideImpl setDeny(long deny) {
        this.deny = deny;
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PermissionOverride)) {
            return false;
        }
        PermissionOverride oPerm = (PermissionOverride)o;
        return this == oPerm || (this.member == null ? oPerm.getMember() == null : this.member.equals(oPerm.getMember())) && this.channel.equals(oPerm.getChannel()) && (this.role == null ? oPerm.getRole() == null : this.role.equals(oPerm.getRole()));
    }

    public int hashCode() {
        return this.member != null ? (this.channel.getId() + this.member.getUser().getId()).hashCode() : (this.channel.getId() + this.role.getId()).hashCode();
    }

    public String toString() {
        IMentionable snowflake = this.member != null ? this.member.getUser() : this.role;
        return "PermOver:(" + (this.member != null ? "M" : "R") + ")" + "(" + this.channel.getId() + " | " + snowflake.getId() + ")";
    }
}

