/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.handle;

import net.dv8tion.jda.client.entities.impl.CallImpl;
import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.client.events.group.GroupUserLeaveEvent;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONObject;

public class ChannelRecipientRemoveHandler
extends SocketHandler {
    public ChannelRecipientRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String groupId = content.getString("channel_id");
        String userId = content.getJSONObject("user").getString("id");
        GroupImpl group = (GroupImpl)this.api.asClient().getGroupById(groupId);
        if (group == null) {
            EventCache.get(this.api).cache(EventCache.Type.CHANNEL, groupId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a CHANNEL_RECIPIENT_REMOVE for a group that is not yet cached! JSON: " + content);
            return null;
        }
        User user = group.getUserMap().remove(userId);
        if (user == null) {
            EventCache.get(this.api).cache(EventCache.Type.USER, userId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a CHANNEL_RECIPIENT_REMOVE for a user that is not yet cached in the group! JSON: " + content);
            return null;
        }
        CallImpl call = (CallImpl)group.getCurrentCall();
        if (call != null) {
            call.getCallUserMap().remove(userId);
        }
        if (user.isFake() && !user.hasPrivateChannel() && this.api.asClient().getRelationshipById(userId) == null && this.api.asClient().getGroups().stream().allMatch(g -> !g.getUsers().contains(user))) {
            this.api.getFakeUserMap().remove(userId);
        }
        this.api.getEventManager().handle(new GroupUserLeaveEvent(this.api, this.responseNumber, group, user));
        return null;
    }
}

