/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.entities.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.dv8tion.jda.client.entities.Call;
import net.dv8tion.jda.client.entities.Friend;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.RestAction;

public class GroupImpl
implements Group {
    private final String id;
    private final JDAImpl api;
    private HashMap<String, User> userMap = new HashMap();
    private Call currentCall;
    private User owner;
    private String name;
    private String iconId;

    public GroupImpl(String id, JDAImpl api) {
        this.id = id;
        this.api = api;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChannelType getType() {
        return ChannelType.GROUP;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getIconUrl() {
        return this.iconId == null ? null : "https://cdn.discordapp.com/channel-icons/" + this.id + "/" + this.iconId + ".jpg";
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    @Override
    public List<User> getUsers() {
        return Collections.unmodifiableList(new ArrayList<User>(this.userMap.values()));
    }

    @Override
    public List<User> getNonFriendUsers() {
        ArrayList nonFriends = new ArrayList();
        this.userMap.forEach((userId, user) -> {
            Friend friend = this.api.asClient().getFriendById((String)userId);
            if (friend == null) {
                nonFriends.add(user);
            }
        });
        return Collections.unmodifiableList(nonFriends);
    }

    @Override
    public List<Friend> getFriends() {
        ArrayList<Friend> friends = new ArrayList<Friend>();
        for (String userId : this.userMap.keySet()) {
            Friend friend = this.api.asClient().getFriendById(userId);
            if (friend == null) continue;
            friends.add(friend);
        }
        return Collections.unmodifiableList(friends);
    }

    @Override
    public RestAction<Call> startCall() {
        return null;
    }

    @Override
    public Call getCurrentCall() {
        return this.currentCall;
    }

    @Override
    public RestAction leaveGroup() {
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    public String toString() {
        return String.format("G:%s(%s)", this.getName(), this.getId());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Group)) {
            return false;
        }
        Group oGroup = (Group)o;
        return this.id.equals(oGroup.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public HashMap<String, User> getUserMap() {
        return this.userMap;
    }

    public GroupImpl setCurrentCall(Call call) {
        this.currentCall = call;
        return this;
    }

    public GroupImpl setOwner(User owner) {
        this.owner = owner;
        return this;
    }

    public GroupImpl setName(String name) {
        this.name = name;
        return this;
    }

    public GroupImpl setIconId(String iconId) {
        this.iconId = iconId;
        return this;
    }

    private void checkNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Provided " + name + " was null!");
        }
    }
}

