/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.track.playback;

import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackState;
import com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerTracker;
import com.sedmelluq.discord.lavaplayer.track.TrackStateListener;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameBuffer;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimordialAudioTrackExecutor
implements AudioTrackExecutor {
    private static final Logger log = LoggerFactory.getLogger(LocalAudioTrackExecutor.class);
    private final AudioTrackInfo trackInfo;
    private final TrackMarkerTracker markerTracker;
    private volatile long position;

    public PrimordialAudioTrackExecutor(AudioTrackInfo trackInfo) {
        this.trackInfo = trackInfo;
        this.markerTracker = new TrackMarkerTracker();
    }

    @Override
    public AudioFrameBuffer getAudioBuffer() {
        return null;
    }

    @Override
    public void execute(TrackStateListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop() {
        log.info("Tried to stop track {} which is not playing.", (Object)this.trackInfo.identifier);
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(long timecode) {
        this.position = timecode;
        this.markerTracker.checkSeekTimecode(timecode);
    }

    @Override
    public AudioTrackState getState() {
        return AudioTrackState.INACTIVE;
    }

    @Override
    public void setMarker(TrackMarker marker) {
        this.markerTracker.set(marker, this.position);
    }

    @Override
    public boolean failedBeforeLoad() {
        return false;
    }

    @Override
    public AudioFrame provide() {
        return this.provide(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public AudioFrame provide(long timeout, TimeUnit unit) {
        return null;
    }

    public void applyStateToExecutor(AudioTrackExecutor executor) {
        if (this.position != 0L) {
            executor.setPosition(0L);
        }
        executor.setMarker(this.markerTracker.remove());
    }
}

