/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegFileLoader;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegFileTrackProvider;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubePersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import me.iblitzkriegi.vixio.org.apache.http.client.utils.URIBuilder;

public class YoutubeMpegStreamAudioTrack
extends MpegAudioTrack {
    private final HttpInterface httpInterface;
    private final URI signedUrl;

    public YoutubeMpegStreamAudioTrack(AudioTrackInfo trackInfo, HttpInterface httpInterface, URI signedUrl) {
        super(trackInfo, null);
        this.httpInterface = httpInterface;
        this.signedUrl = signedUrl;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) {
        localExecutor.executeProcessingLoop(() -> this.execute(localExecutor), null);
    }

    private void execute(LocalAudioTrackExecutor localExecutor) throws InterruptedException {
        TrackState state = new TrackState();
        try {
            while (!state.finished) {
                this.processNextSegment(localExecutor, state);
                state.relativeSequence++;
            }
        }
        finally {
            if (state.trackConsumer != null) {
                state.trackConsumer.close();
            }
        }
    }

    private void processNextSegment(LocalAudioTrackExecutor localExecutor, TrackState state) throws InterruptedException {
        URI segmentUrl = this.getNextSegmentUrl(state);
        try (YoutubePersistentHttpStream stream = new YoutubePersistentHttpStream(this.httpInterface, segmentUrl, Long.MAX_VALUE);){
            MpegFileTrackProvider fileReader;
            if (stream.checkStatusCode() == 204) {
                state.finished = true;
                return;
            }
            MpegFileLoader file = new MpegFileLoader(stream);
            file.parseHeaders();
            state.absoluteSequence = this.extractAbsoluteSequenceFromEvent(file.getLastEventMessage());
            if (state.trackConsumer == null) {
                state.trackConsumer = this.loadAudioTrack(file, localExecutor.getProcessingContext());
            }
            if ((fileReader = file.loadReader(state.trackConsumer)) == null) {
                throw new FriendlyException("Unknown MP4 format.", FriendlyException.Severity.SUSPICIOUS, null);
            }
            fileReader.provideFrames();
            stream.releaseConnection();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private URI getNextSegmentUrl(TrackState state) {
        URIBuilder builder = new URIBuilder(this.signedUrl).addParameter("rn", String.valueOf(state.relativeSequence)).addParameter("rbuf", "0");
        if (state.absoluteSequence != null) {
            builder.addParameter("sq", String.valueOf(state.absoluteSequence + 1L));
        }
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Long extractAbsoluteSequenceFromEvent(byte[] data) {
        if (data == null) {
            return null;
        }
        String message = new String(data, StandardCharsets.UTF_8);
        String sequence = DataFormatTools.extractBetween(message, "Sequence-Number: ", "\r\n");
        return sequence != null ? Long.valueOf(sequence) : null;
    }

    private static class TrackState {
        private long relativeSequence;
        private Long absoluteSequence;
        private MpegTrackConsumer trackConsumer;
        private boolean finished;

        private TrackState() {
        }
    }
}

