/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.format.transcoder;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class PcmChunkDecoder
implements AudioChunkDecoder {
    private final ByteBuffer encodedAsByte;
    private final ShortBuffer encodedAsShort;

    public PcmChunkDecoder(AudioDataFormat format) {
        this.encodedAsByte = ByteBuffer.allocate(format.bufferSize(2));
        if (format.codec == AudioDataFormat.Codec.PCM_S16_LE) {
            this.encodedAsByte.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.encodedAsShort = this.encodedAsByte.asShortBuffer();
    }

    @Override
    public void decode(byte[] encoded, ShortBuffer buffer) {
        buffer.clear();
        this.encodedAsByte.clear();
        this.encodedAsByte.put(encoded);
        this.encodedAsShort.clear();
        this.encodedAsShort.limit(this.encodedAsByte.position() / 2);
        buffer.put(this.encodedAsShort);
    }

    @Override
    public void close() {
    }
}

