/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.format;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import javax.sound.sampled.AudioFormat;

public class AudioDataFormatTools {
    public static final AudioFormat.Encoding OPUS_ENCODING = new AudioFormat.Encoding("OPUS");

    public static AudioFormat toAudioFormat(AudioDataFormat format) {
        if (format.codec == AudioDataFormat.Codec.PCM_S16_BE || format.codec == AudioDataFormat.Codec.PCM_S16_LE) {
            return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.sampleRate, 16, format.channelCount, format.channelCount * 2, format.sampleRate, format.codec == AudioDataFormat.Codec.PCM_S16_BE);
        }
        if (format.codec == AudioDataFormat.Codec.OPUS) {
            return new AudioFormat(OPUS_ENCODING, format.sampleRate, -1, format.channelCount, -1, -1.0f, false);
        }
        throw new IllegalStateException("All codecs should be checked.");
    }
}

