/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.matroska.format;

import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaEbmlReader;
import java.nio.ByteBuffer;

public class MatroskaFixedBlock {
    private final ByteBuffer buffer;
    private int startPosition;
    private int timecode;
    private int trackNumber;
    private boolean keyFrame;
    private int[] offsets;
    private int[] sizes;

    public MatroskaFixedBlock(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public int getTimecode() {
        return this.timecode;
    }

    public int getTrackNumber() {
        return this.trackNumber;
    }

    public boolean isKeyFrame() {
        return this.keyFrame;
    }

    public int getFrameCount() {
        return this.sizes == null ? 1 : this.sizes.length;
    }

    public void parseHeader() {
        this.trackNumber = (int)MatroskaEbmlReader.readEbmlInteger(this.buffer, null);
        this.timecode = this.buffer.getShort();
        int flags = this.buffer.get() & 0xFF;
        this.keyFrame = (flags & 0x80) != 0;
        int laceType = (flags & 6) >> 1;
        if (laceType != 0) {
            this.parseLacing(laceType, this.buffer.get() & 0xFF);
        }
        this.startPosition = this.buffer.position();
    }

    public ByteBuffer getFrameBuffer(int index) {
        ByteBuffer frameBuffer = this.buffer.duplicate();
        if (this.sizes == null) {
            if (index > 0) {
                throw new IllegalArgumentException("Frame index out of bounds.");
            }
            frameBuffer.limit(this.buffer.limit());
            frameBuffer.position(this.startPosition);
        } else {
            if (index >= this.sizes.length) {
                throw new IllegalArgumentException("Frame index out of bounds.");
            }
            frameBuffer.limit(this.offsets[index] + this.sizes[index]);
            frameBuffer.position(this.offsets[index]);
        }
        return frameBuffer;
    }

    private void parseLacing(int laceType, int length) {
        this.sizes = new int[length + 1];
        this.offsets = new int[length + 1];
        switch (laceType) {
            case 1: {
                this.parseXiphLaceSizes(this.sizes);
                break;
            }
            case 2: {
                this.parseFixedLaceSizes(this.sizes);
                break;
            }
            default: {
                this.parseEbmlLaceSizes(this.sizes);
            }
        }
        this.offsets[0] = this.buffer.position();
        for (int i = 1; i < this.sizes.length; ++i) {
            this.offsets[i] = this.offsets[i - 1] + this.sizes[i - 1];
        }
    }

    private void parseXiphLaceSizes(int[] laceSizes) {
        int sizeTotal = 0;
        for (int i = 0; i < laceSizes.length - 1; ++i) {
            int value;
            do {
                value = this.buffer.get() & 0xFF;
                int n = i;
                laceSizes[n] = laceSizes[n] + value;
            } while (value == 255);
            sizeTotal += laceSizes[i];
        }
        laceSizes[laceSizes.length - 1] = this.buffer.remaining() - sizeTotal;
    }

    private void parseFixedLaceSizes(int[] laceSizes) {
        int size = this.buffer.remaining() / laceSizes.length;
        for (int i = 0; i < laceSizes.length; ++i) {
            laceSizes[i] = size;
        }
    }

    private void parseEbmlLaceSizes(int[] laceSizes) {
        laceSizes[0] = (int)MatroskaEbmlReader.readEbmlInteger(this.buffer, null);
        int sizeTotal = laceSizes[0];
        for (int i = 1; i < laceSizes.length - 1; ++i) {
            laceSizes[i] = laceSizes[i - 1] + (int)MatroskaEbmlReader.readEbmlInteger(this.buffer, MatroskaEbmlReader.Type.LACE_SIGNED);
            sizeTotal += laceSizes[i];
        }
        laceSizes[laceSizes.length - 1] = this.buffer.remaining() - sizeTotal;
    }
}

