/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;

public class MediaContainerDetectionResult {
    private final AudioTrackInfo trackInfo;
    private final MediaContainerProbe containerProbe;
    private final AudioReference reference;
    private final String unsupportedReason;

    public MediaContainerDetectionResult(MediaContainerProbe containerProbe, AudioTrackInfo trackInfo) {
        this.trackInfo = trackInfo;
        this.containerProbe = containerProbe;
        this.unsupportedReason = null;
        this.reference = null;
    }

    public MediaContainerDetectionResult(MediaContainerProbe containerProbe, AudioReference reference) {
        this.trackInfo = null;
        this.containerProbe = containerProbe;
        this.unsupportedReason = null;
        this.reference = reference;
    }

    public MediaContainerDetectionResult(MediaContainerProbe containerProbe, String unsupportedReason) {
        this.trackInfo = null;
        this.containerProbe = containerProbe;
        this.unsupportedReason = unsupportedReason;
        this.reference = null;
    }

    public MediaContainerDetectionResult() {
        this.trackInfo = null;
        this.containerProbe = null;
        this.unsupportedReason = null;
        this.reference = null;
    }

    public boolean isContainerDetected() {
        return this.containerProbe != null;
    }

    public MediaContainerProbe getContainerProbe() {
        return this.containerProbe;
    }

    public boolean isSupportedFile() {
        return this.isContainerDetected() && this.unsupportedReason == null;
    }

    public String getUnsupportedReason() {
        return this.unsupportedReason;
    }

    public AudioTrackInfo getTrackInfo() {
        return this.trackInfo;
    }

    public boolean isReference() {
        return this.reference != null;
    }

    public AudioReference getReference() {
        return this.reference;
    }
}

