/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.http;

import com.mashape.unirest.http.Headers;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.ObjectMapper;
import com.mashape.unirest.http.options.Option;
import com.mashape.unirest.http.options.Options;
import com.mashape.unirest.http.utils.ResponseUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import me.iblitzkriegi.vixio.org.apache.http.Header;
import me.iblitzkriegi.vixio.org.apache.http.HttpEntity;
import me.iblitzkriegi.vixio.org.apache.http.StatusLine;
import me.iblitzkriegi.vixio.org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse<T> {
    private int statusCode;
    private String statusText;
    private Headers headers;
    private InputStream rawBody;
    private T body;

    public HttpResponse(me.iblitzkriegi.vixio.org.apache.http.HttpResponse response, Class<T> responseClass) {
        HttpEntity responseEntity;
        block13: {
            Header[] allHeaders;
            this.headers = new Headers();
            responseEntity = response.getEntity();
            ObjectMapper objectMapper = (ObjectMapper)Options.getOption(Option.OBJECT_MAPPER);
            for (Header header : allHeaders = response.getAllHeaders()) {
                String headerName = header.getName();
                ArrayList<String> list = (ArrayList<String>)this.headers.get(headerName);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(header.getValue());
                this.headers.put(headerName, list);
            }
            StatusLine statusLine = response.getStatusLine();
            this.statusCode = statusLine.getStatusCode();
            this.statusText = statusLine.getReasonPhrase();
            if (responseEntity != null) {
                String responseCharset;
                String charset = "UTF-8";
                Header contentType = responseEntity.getContentType();
                if (contentType != null && (responseCharset = ResponseUtils.getCharsetFromContentType(contentType.getValue())) != null && !responseCharset.trim().equals("")) {
                    charset = responseCharset;
                }
                try {
                    byte[] rawBody;
                    try {
                        InputStream responseInputStream = responseEntity.getContent();
                        if (ResponseUtils.isGzipped(responseEntity.getContentEncoding())) {
                            responseInputStream = new GZIPInputStream(responseEntity.getContent());
                        }
                        rawBody = ResponseUtils.getBytes(responseInputStream);
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                    this.rawBody = new ByteArrayInputStream(rawBody);
                    if (JsonNode.class.equals(responseClass)) {
                        String jsonString = new String(rawBody, charset).trim();
                        this.body = new JsonNode(jsonString);
                        break block13;
                    }
                    if (String.class.equals(responseClass)) {
                        this.body = new String(rawBody, charset);
                        break block13;
                    }
                    if (InputStream.class.equals(responseClass)) {
                        this.body = this.rawBody;
                        break block13;
                    }
                    if (objectMapper != null) {
                        this.body = objectMapper.readValue(new String(rawBody, charset), responseClass);
                        break block13;
                    }
                    throw new Exception("Only String, JsonNode and InputStream are supported, or an ObjectMapper implementation is required.");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        EntityUtils.consumeQuietly(responseEntity);
    }

    public int getStatus() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public InputStream getRawBody() {
        return this.rawBody;
    }

    public T getBody() {
        return this.body;
    }
}

