/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.utils.SimpleLog;
import org.json.JSONObject;

public class GuildLock {
    public static SimpleLog LOG = SimpleLog.getLog("JDAGuildLock");
    private static Map<JDA, GuildLock> locks = new HashMap<JDA, GuildLock>();
    private final JDA api;
    private final Map<String, List<JSONObject>> cache = new HashMap<String, List<JSONObject>>();
    private final Set<String> cached = new HashSet<String>();

    public static synchronized GuildLock get(JDA jda) {
        if (!locks.containsKey(jda)) {
            locks.put(jda, new GuildLock(jda));
        }
        return locks.get(jda);
    }

    public boolean isLocked(String guildId) {
        return this.cached.contains(guildId);
    }

    public void lock(String guildId) {
        if (!this.isLocked(guildId)) {
            this.cached.add(guildId);
            this.cache.put(guildId, new LinkedList());
        }
    }

    public void unlock(String guildId) {
        if (this.isLocked(guildId)) {
            this.cached.remove(guildId);
            List<JSONObject> events = this.cache.remove(guildId);
            if (events.size() > 0) {
                LOG.debug("Replaying " + events.size() + " events for unlocked guild with id " + guildId);
                ((JDAImpl)this.api).getClient().handle(events);
                LOG.debug("Finished replaying events for guild with id " + guildId);
            }
        }
    }

    public void queue(String guildId, JSONObject event) {
        if (this.isLocked(guildId)) {
            LOG.debug("Queueing up event for guild with id " + guildId + ": " + event.toString());
            this.cache.get(guildId).add(event);
        }
    }

    public void clear() {
        this.cache.clear();
        this.cached.clear();
    }

    private GuildLock(JDA api) {
        this.api = api;
    }
}

