/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.regex.Pattern;
import net.dv8tion.jda.client.events.message.group.GroupMessageReceivedEvent;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageType;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.message.MessageReceivedEvent;
import net.dv8tion.jda.core.events.message.guild.GuildMessageReceivedEvent;
import net.dv8tion.jda.core.events.message.priv.PrivateMessageReceivedEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.GuildLock;
import net.dv8tion.jda.core.requests.WebSocketClient;
import org.json.JSONObject;

public class MessageCreateHandler
extends SocketHandler {
    private static final Pattern invitePattern = Pattern.compile("\\bhttps://(?:www\\.)?discord(?:\\.gg|app\\.com/invite)/([a-zA-Z0-9-]+)\\b");

    public MessageCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        MessageType type = MessageType.fromId(content.getInt("type"));
        switch (type) {
            case DEFAULT: {
                return this.handleDefaultMessage(content);
            }
        }
        WebSocketClient.LOG.debug("JDA received a message of unknown type. Type: " + (Object)((Object)type) + "  JSON: " + content);
        return null;
    }

    private String handleDefaultMessage(JSONObject content) {
        Message message;
        try {
            message = EntityBuilder.get(this.api).createMessage(content, true);
        }
        catch (IllegalArgumentException e) {
            switch (e.getMessage()) {
                case "MISSING_CHANNEL": {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("channel_id"), () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("Received a message for a channel that JDA does not currently have cached");
                    return null;
                }
                case "MISSING_USER": {
                    EventCache.get(this.api).cache(EventCache.Type.USER, content.getJSONObject("author").getString("id"), () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("Received a message for a user that JDA does not currently have cached");
                    return null;
                }
            }
            throw e;
        }
        switch (message.getChannelType()) {
            case TEXT: {
                TextChannel channel = message.getTextChannel();
                if (GuildLock.get(this.api).isLocked(channel.getGuild().getId())) {
                    return channel.getGuild().getId();
                }
                this.api.getEventManager().handle(new GuildMessageReceivedEvent(this.api, this.responseNumber, message));
                break;
            }
            case PRIVATE: {
                this.api.getEventManager().handle(new PrivateMessageReceivedEvent(this.api, this.responseNumber, message));
                break;
            }
            case GROUP: {
                this.api.getEventManager().handle(new GroupMessageReceivedEvent(this.api, this.responseNumber, message));
                break;
            }
            default: {
                WebSocketClient.LOG.warn("Received a MESSAGE_CREATE with a unknown MessageChannel ChannelType. JSON: " + content);
                return null;
            }
        }
        this.api.getEventManager().handle(new MessageReceivedEvent(this.api, this.responseNumber, message));
        return null;
    }
}

