/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class GuildSyncHandler
extends SocketHandler {
    public GuildSyncHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String guildId = content.getString("id");
        if (!this.api.getGuildMap().containsKey(guildId)) {
            JDAImpl.LOG.fatal("Received a GUILD_SYNC for a Guild that does not yet exist in JDA's guild cache. This is a BAD ERROR FOR CLIENTS!");
            return null;
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
        JSONArray members = content.getJSONArray("members");
        JSONArray presences = content.getJSONArray("presences");
        EntityBuilder.get(this.api).handleGuildSync(guild, members, presences);
        return null;
    }
}

