/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.client.events.group.GroupJoinEvent;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.channel.priv.PrivateChannelCreateEvent;
import net.dv8tion.jda.core.events.channel.text.TextChannelCreateEvent;
import net.dv8tion.jda.core.events.channel.voice.VoiceChannelCreateEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.GuildLock;
import org.json.JSONObject;

public class ChannelCreateHandler
extends SocketHandler {
    public ChannelCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        if ((type == ChannelType.TEXT || type == ChannelType.VOICE) && GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        switch (type) {
            case TEXT: {
                this.api.getEventManager().handle(new TextChannelCreateEvent(this.api, this.responseNumber, EntityBuilder.get(this.api).createTextChannel(content, content.getString("guild_id"))));
                break;
            }
            case VOICE: {
                this.api.getEventManager().handle(new VoiceChannelCreateEvent(this.api, this.responseNumber, EntityBuilder.get(this.api).createVoiceChannel(content, content.getString("guild_id"))));
                break;
            }
            case PRIVATE: {
                this.api.getEventManager().handle(new PrivateChannelCreateEvent(this.api, this.responseNumber, EntityBuilder.get(this.api).createPrivateChannel(content)));
                break;
            }
            case GROUP: {
                this.api.getEventManager().handle(new GroupJoinEvent(this.api, this.responseNumber, EntityBuilder.get(this.api).createGroup(content)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Discord provided an CREATE_CHANNEL event with an unknown channel type! JSON: " + content);
            }
        }
        EventCache.get(this.api).playbackCache(EventCache.Type.CHANNEL, content.getString("id"));
        return null;
    }
}

