/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.json.JSONObject;

public class UserImpl
implements User {
    protected final String id;
    protected final JDAImpl api;
    protected String name;
    protected String discriminator;
    protected String avatarId;
    protected PrivateChannel privateChannel;
    protected boolean bot;
    protected boolean fake = false;

    public UserImpl(String id, JDAImpl api) {
        this.id = id;
        this.api = api;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDiscriminator() {
        return this.discriminator;
    }

    @Override
    public String getAvatarId() {
        return this.avatarId;
    }

    @Override
    public String getAvatarUrl() {
        return this.getAvatarId() == null ? null : "https://cdn.discordapp.com/avatars/" + this.getId() + "/" + this.getAvatarId() + ".jpg";
    }

    @Override
    public String getDefaultAvatarId() {
        return DefaultAvatar.values()[Integer.parseInt(this.getDiscriminator()) % DefaultAvatar.values().length].toString();
    }

    @Override
    public String getDefaultAvatarUrl() {
        return "https://discordapp.com/assets/" + this.getDefaultAvatarId() + ".png";
    }

    @Override
    public String getEffectiveAvatarUrl() {
        return this.getAvatarUrl() == null ? this.getDefaultAvatarUrl() : this.getAvatarUrl();
    }

    @Override
    public boolean hasPrivateChannel() {
        return this.privateChannel != null;
    }

    @Override
    public RestAction<PrivateChannel> openPrivateChannel() {
        if (this.privateChannel != null) {
            return new RestAction.EmptyRestAction<PrivateChannel>(this.privateChannel);
        }
        if (this.fake) {
            throw new IllegalStateException("Cannot open a PrivateChannel with a Fake user.");
        }
        Route.CompiledRoute route = Route.Self.CREATE_PRIVATE_CHANNEL.compile(new String[0]);
        JSONObject body = new JSONObject().put("recipient_id", this.getId());
        return new RestAction<PrivateChannel>((JDA)this.api, route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    PrivateChannel priv;
                    UserImpl.this.privateChannel = priv = EntityBuilder.get(this.api).createPrivateChannel(response.getObject());
                    request.onSuccess(priv);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public PrivateChannel getPrivateChannel() {
        if (!this.hasPrivateChannel()) {
            throw new IllegalStateException("There is no PrivateChannel for this user yet! Use User#openPrivateChannel() first!");
        }
        return this.privateChannel;
    }

    @Override
    public boolean isBot() {
        return this.bot;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public String getAsMention() {
        return "<@" + this.getId() + '>';
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User oUser = (User)o;
        return this == oUser || this.getId().equals(oUser.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "U:" + this.getName() + '(' + this.getId() + ')';
    }

    public UserImpl setName(String name) {
        this.name = name;
        return this;
    }

    public UserImpl setDiscriminator(String discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public UserImpl setAvatarId(String avatarId) {
        this.avatarId = avatarId;
        return this;
    }

    public UserImpl setPrivateChannel(PrivateChannel privateChannel) {
        this.privateChannel = privateChannel;
        return this;
    }

    public UserImpl setBot(boolean bot) {
        this.bot = bot;
        return this;
    }

    public UserImpl setFake(boolean fake) {
        this.fake = fake;
        return this;
    }

    public static enum DefaultAvatar {
        BLURPLE("6debd47ed13483642cf09e832ed0bc1b"),
        GREY("322c936a8c8be1b803cd94861bdfa868"),
        GREEN("dd4dbc0016779df1378e7812eabaa04d"),
        ORANGE("0e291f67c9274a1abdddeb3fd919cbaa"),
        RED("1cbd08c76f8af6dddce02c5138971129");

        private final String text;

        private DefaultAvatar(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

