/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.json.JSONArray;
import org.json.JSONObject;

public class MessageReaction {
    private final MessageChannel channel;
    private final ReactionEmote emote;
    private final String messageId;
    private final boolean self;
    private final int count;

    public MessageReaction(MessageChannel channel, ReactionEmote emote, String messageId, boolean self, int count) {
        this.channel = channel;
        this.emote = emote;
        this.messageId = messageId;
        this.self = self;
        this.count = count;
    }

    public boolean isSelf() {
        return this.self;
    }

    public int getCount() {
        return this.count;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public ReactionEmote getEmote() {
        return this.emote;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public JDA getJDA() {
        return this.channel.getJDA();
    }

    public RestAction<List<User>> getUsers() {
        return this.getUsers(100);
    }

    public RestAction<List<User>> getUsers(int amount) {
        if (amount < 1 || amount > 100) {
            throw new IllegalArgumentException("Amount is out of range 1-100!");
        }
        String code = this.emote.isEmote() ? this.emote.getName() + ":" + this.emote.getId() : MessageReaction.encode(this.emote.getName());
        Route.CompiledRoute route = Route.Messages.GET_REACTION_USERS.compile(this.channel.getId(), this.messageId, code, String.valueOf(amount));
        return new RestAction<List<User>>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                LinkedList<User> users = new LinkedList<User>();
                JSONArray array = response.getArray();
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject json = array.getJSONObject(i);
                    String userId = json.getString("id");
                    User user = this.api.getUserById(userId);
                    if (user == null) {
                        user = this.api.getFakeUserMap().get(userId);
                    }
                    if (user == null) {
                        user = EntityBuilder.get(this.api).createFakeUser(json, false);
                    }
                    users.add(user);
                }
                request.onSuccess(users);
            }
        };
    }

    public RestAction<Void> removeReaction() {
        return this.removeReaction(this.getJDA().getSelfUser());
    }

    public RestAction<Void> removeReaction(User user) {
        if (user == null) {
            throw new IllegalArgumentException("Provided User was null!");
        }
        if (!user.equals(this.getJDA().getSelfUser())) {
            if (this.channel.getType() == ChannelType.TEXT) {
                Channel channel = (Channel)((Object)this.channel);
                if (!channel.getGuild().getSelfMember().hasPermission(channel, Permission.MESSAGE_MANAGE)) {
                    throw new PermissionException(Permission.MESSAGE_MANAGE);
                }
            } else {
                throw new PermissionException("Unable to remove Reaction of other user in non-text channel!");
            }
        }
        String code = this.emote.isEmote() ? this.emote.getName() + ":" + this.emote.getId() : MessageReaction.encode(this.emote.getName());
        Route.CompiledRoute route = Route.Messages.REMOVE_REACTION.compile(this.channel.getId(), this.messageId, code, user.getId());
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public boolean equals(Object obj) {
        return obj instanceof MessageReaction && ((MessageReaction)obj).emote.equals(this.emote) && ((MessageReaction)obj).self == this.self && ((MessageReaction)obj).messageId.equals(this.messageId);
    }

    public String toString() {
        return "MR:(M:(" + this.messageId + ") / " + this.emote + ")";
    }

    private static String encode(String chars) {
        try {
            return URLEncoder.encode(chars, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ReactionEmote
    implements ISnowflake {
        private final JDA api;
        private final String name;
        private final String id;

        public ReactionEmote(String name, String id, JDA api) {
            this.name = name;
            this.id = id;
            this.api = api;
        }

        public ReactionEmote(Emote emote) {
            this(emote.getName(), emote.getId(), emote.getJDA());
        }

        public boolean isEmote() {
            return this.id != null;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Emote getEmote() {
            if (!this.isEmote()) {
                return null;
            }
            Emote e = this.api.getEmoteById(this.id);
            return e != null ? e : new EmoteImpl(this.id, this.api).setName(this.name);
        }

        public JDA getJDA() {
            return this.api;
        }

        public boolean equals(Object obj) {
            return obj instanceof ReactionEmote && Objects.equals(((ReactionEmote)obj).getId(), this.id) && ((ReactionEmote)obj).getName().equals(this.name);
        }

        public String toString() {
            return "RE:" + (this.isEmote() ? this.getEmote() : this.getName() + "(" + this.getId() + ")");
        }
    }
}

