/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.util;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import me.iblitzkriegi.vixio.effects.EffLogin;
import me.iblitzkriegi.vixio.events.EvntAudioPlayerTrackEnd;
import me.iblitzkriegi.vixio.events.EvntAudioPlayerTrackStart;
import net.dv8tion.jda.core.JDA;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class TrackScheduler
extends AudioEventAdapter {
    private final AudioPlayer player;
    private final BlockingQueue<AudioTrack> queue;

    public TrackScheduler(AudioPlayer player) {
        this.player = player;
        this.queue = new LinkedBlockingQueue<AudioTrack>();
    }

    public void queue(AudioTrack track) {
        if (!this.player.startTrack(track, true)) {
            this.queue.offer(track);
        }
    }

    public void nextTrack() {
        this.player.startTrack((AudioTrack)this.queue.poll(), false);
    }

    @Override
    public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
        if (endReason.mayStartNext) {
            this.nextTrack();
        }
        EvntAudioPlayerTrackEnd efc = new EvntAudioPlayerTrackEnd(player, track, endReason);
        Bukkit.getServer().getPluginManager().callEvent((Event)efc);
    }

    public AudioPlayer getPlayer() {
        return this.player;
    }

    public void resetPlayer() {
        this.queue.clear();
    }

    @Override
    public void onTrackStart(AudioPlayer player, AudioTrack track) {
        JDA jda = EffLogin.bots.get("t");
        EvntAudioPlayerTrackStart efc = new EvntAudioPlayerTrackStart(player, track);
        Bukkit.getServer().getPluginManager().callEvent((Event)efc);
    }

    public ArrayList getQueue() {
        return new ArrayList<AudioTrack>(this.queue);
    }
}

