/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.track.playback;

import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackState;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerTracker;
import com.sedmelluq.discord.lavaplayer.track.TrackStateListener;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameBuffer;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAudioTrackExecutor
implements AudioTrackExecutor {
    private static final Logger log = LoggerFactory.getLogger(LocalAudioTrackExecutor.class);
    private final InternalAudioTrack audioTrack;
    private final AudioProcessingContext processingContext;
    private final boolean useSeekGhosting;
    private final AudioFrameBuffer frameBuffer;
    private final AtomicReference<Thread> playingThread = new AtomicReference();
    private final AtomicBoolean isStopping = new AtomicBoolean(false);
    private final AtomicLong pendingSeek = new AtomicLong(-1L);
    private final AtomicLong lastFrameTimecode = new AtomicLong(0L);
    private final AtomicReference<AudioTrackState> state = new AtomicReference<AudioTrackState>(AudioTrackState.INACTIVE);
    private final Object actionSynchronizer = new Object();
    private final TrackMarkerTracker markerTracker = new TrackMarkerTracker();
    private volatile Throwable trackException;

    public LocalAudioTrackExecutor(InternalAudioTrack audioTrack, AudioConfiguration configuration, AtomicInteger volumeLevel, boolean useSeekGhosting, int bufferDuration) {
        this.audioTrack = audioTrack;
        this.frameBuffer = new AudioFrameBuffer(bufferDuration);
        this.processingContext = new AudioProcessingContext(configuration, this.frameBuffer, volumeLevel);
        this.useSeekGhosting = useSeekGhosting;
    }

    public AudioProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    @Override
    public AudioFrameBuffer getAudioBuffer() {
        return this.frameBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TrackStateListener listener) {
        block16: {
            block17: {
                Object object;
                boolean interrupted = false;
                if (!this.playingThread.compareAndSet(null, Thread.currentThread())) break block17;
                log.debug("Starting to play track {} locally with listener {}", (Object)this.audioTrack.getInfo().identifier, (Object)listener);
                this.state.set(AudioTrackState.LOADING);
                try {
                    this.audioTrack.process(this);
                    log.info("Playing track {} finished or was stopped.", (Object)this.audioTrack.getIdentifier());
                    object = this.actionSynchronizer;
                }
                catch (Throwable e) {
                    Object object2;
                    try {
                        interrupted = e instanceof InterruptedException || Thread.interrupted();
                        this.frameBuffer.setTerminateOnEmpty();
                        FriendlyException exception = ExceptionTools.wrapUnfriendlyExceptions("Something broke when playing the track.", FriendlyException.Severity.FAULT, e);
                        ExceptionTools.log(log, exception, "playback of " + this.audioTrack.getIdentifier());
                        this.trackException = exception;
                        listener.onTrackException(this.audioTrack, exception);
                        ExceptionTools.rethrowErrors(e);
                        object2 = this.actionSynchronizer;
                    }
                    catch (Throwable throwable) {
                        Object object3 = this.actionSynchronizer;
                        synchronized (object3) {
                            interrupted = interrupted || Thread.interrupted();
                            this.playingThread.compareAndSet(Thread.currentThread(), null);
                            this.markerTracker.trigger(TrackMarkerHandler.MarkerState.ENDED);
                            this.state.set(AudioTrackState.FINISHED);
                        }
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        throw throwable;
                    }
                    synchronized (object2) {
                        interrupted = interrupted || Thread.interrupted();
                        this.playingThread.compareAndSet(Thread.currentThread(), null);
                        this.markerTracker.trigger(TrackMarkerHandler.MarkerState.ENDED);
                        this.state.set(AudioTrackState.FINISHED);
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    break block16;
                }
                synchronized (object) {
                    interrupted = interrupted || Thread.interrupted();
                    this.playingThread.compareAndSet(Thread.currentThread(), null);
                    this.markerTracker.trigger(TrackMarkerHandler.MarkerState.ENDED);
                    this.state.set(AudioTrackState.FINISHED);
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                break block16;
            }
            log.warn("Tried to start an already playing track {}", (Object)this.audioTrack.getIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.actionSynchronizer;
        synchronized (object) {
            Thread thread = this.playingThread.get();
            if (thread != null) {
                log.debug("Requesting stop for track {}", (Object)this.audioTrack.getIdentifier());
                this.isStopping.compareAndSet(false, true);
                thread.interrupt();
            } else {
                log.debug("Tried to stop track {} which is not playing.", (Object)this.audioTrack.getIdentifier());
            }
        }
    }

    public boolean checkStopped() {
        return this.isStopping.compareAndSet(true, false);
    }

    public void waitOnEnd() throws InterruptedException {
        this.frameBuffer.setTerminateOnEmpty();
        this.frameBuffer.waitForTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean interrupt() {
        Object object = this.actionSynchronizer;
        synchronized (object) {
            Thread thread = this.playingThread.get();
            if (thread != null) {
                thread.interrupt();
                return true;
            }
            return false;
        }
    }

    @Override
    public long getPosition() {
        long seek = this.pendingSeek.get();
        return seek != -1L ? seek : this.lastFrameTimecode.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPosition(long timecode) {
        if (!this.audioTrack.isSeekable()) {
            return;
        }
        Object object = this.actionSynchronizer;
        synchronized (object) {
            if (timecode < 0L) {
                timecode = 0L;
            }
            this.pendingSeek.set(timecode);
            if (!this.useSeekGhosting) {
                this.frameBuffer.clear();
            }
            if (this.interrupt()) {
                log.debug("Interrupting playing thread to perform a seek {}", (Object)this.audioTrack.getIdentifier());
            } else {
                log.debug("Seeking on a track which is not playing {}", (Object)this.audioTrack.getIdentifier());
            }
        }
    }

    @Override
    public AudioTrackState getState() {
        return this.state.get();
    }

    private boolean isPerformingSeek() {
        return this.pendingSeek.get() != -1L || this.useSeekGhosting && this.frameBuffer.hasClearOnInsert();
    }

    @Override
    public void setMarker(TrackMarker marker) {
        this.markerTracker.set(marker, this.getPosition());
    }

    @Override
    public boolean failedBeforeLoad() {
        return this.trackException != null && !this.frameBuffer.hasReceivedFrames();
    }

    public void executeProcessingLoop(ReadExecutor readExecutor, SeekExecutor seekExecutor) {
        boolean proceed = true;
        this.checkPendingSeek(seekExecutor);
        while (proceed) {
            this.state.set(AudioTrackState.PLAYING);
            proceed = false;
            try {
                readExecutor.performRead();
                this.waitOnEnd();
            }
            catch (InterruptedException interruption) {
                Thread.interrupted();
                if (this.checkStopped()) {
                    proceed = false;
                    this.markerTracker.trigger(TrackMarkerHandler.MarkerState.STOPPED);
                    continue;
                }
                if (this.checkPendingSeek(seekExecutor)) {
                    proceed = true;
                    continue;
                }
                Thread.currentThread().interrupt();
                throw new FriendlyException("The track was unexpectedly terminated.", FriendlyException.Severity.SUSPICIOUS, interruption);
            }
            catch (Exception e) {
                throw ExceptionTools.wrapUnfriendlyExceptions("Something went wrong when decoding the track.", FriendlyException.Severity.FAULT, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPendingSeek(SeekExecutor seekExecutor) {
        if (!this.audioTrack.isSeekable()) {
            return false;
        }
        Object object = this.actionSynchronizer;
        synchronized (object) {
            long seekPosition = this.pendingSeek.get();
            if (seekPosition != -1L) {
                log.debug("Track {} interrupted for seeking to {}.", (Object)this.audioTrack.getIdentifier(), (Object)seekPosition);
                try {
                    this.performSeek(seekExecutor, seekPosition);
                }
                catch (Exception e) {
                    throw ExceptionTools.wrapUnfriendlyExceptions("Something went wrong when seeking to a position.", FriendlyException.Severity.FAULT, e);
                }
                return true;
            }
        }
        return false;
    }

    private void performSeek(SeekExecutor seekExecutor, long seekPosition) {
        this.state.set(AudioTrackState.SEEKING);
        if (this.useSeekGhosting) {
            this.frameBuffer.setClearOnInsert();
        } else {
            this.frameBuffer.clear();
        }
        seekExecutor.performSeek(seekPosition);
        this.pendingSeek.set(-1L);
        this.markerTracker.checkSeekTimecode(seekPosition);
    }

    @Override
    public AudioFrame provide() {
        AudioFrame frame = this.frameBuffer.provide();
        if (frame != null && !frame.isTerminator()) {
            if (!this.isPerformingSeek()) {
                this.markerTracker.checkPlaybackTimecode(frame.timecode);
            }
            this.lastFrameTimecode.set(frame.timecode);
        }
        return frame;
    }

    public static interface SeekExecutor {
        public void performSeek(long var1);
    }

    public static interface ReadExecutor {
        public void performRead() throws InterruptedException;
    }
}

