/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools;

import com.sedmelluq.discord.lavaplayer.tools.DaemonThreadFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorTools {
    private static final Logger log = LoggerFactory.getLogger(ExecutorTools.class);
    private static final long WAIT_TIME = 1000L;

    public static void shutdownExecutor(ExecutorService executorService, String description) {
        if (executorService == null) {
            return;
        }
        log.debug("Shutting down executor {}", (Object)description);
        executorService.shutdownNow();
        try {
            if (!executorService.awaitTermination(1000L, TimeUnit.SECONDS)) {
                log.debug("Executor {} did not shut down in {}", (Object)description, (Object)1000L);
            } else {
                log.debug("Executor {} successfully shut down", (Object)description);
            }
        }
        catch (InterruptedException e) {
            log.debug("Received an interruption while shutting down executor {}", (Object)description);
            Thread.currentThread().interrupt();
        }
    }

    public static ExecutorService createEagerlyScalingExecutor(int coreSize, int maximumSize, long timeout, String poolName) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, maximumSize, timeout, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new EagerlyScalingTaskQueue(), new DaemonThreadFactory(poolName));
        executor.setRejectedExecutionHandler(new EagerlyScalingRejectionHandler());
        return executor;
    }

    private static class EagerlyScalingRejectionHandler
    implements RejectedExecutionHandler {
        private EagerlyScalingRejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(runnable);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class EagerlyScalingTaskQueue
    extends LinkedBlockingQueue<Runnable> {
        private EagerlyScalingTaskQueue() {
        }

        @Override
        public boolean offer(Runnable runnable) {
            return this.isEmpty() && super.offer(runnable);
        }
    }
}

