/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.natives.aac;

import com.sedmelluq.discord.lavaplayer.natives.NativeResourceHolder;
import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoderLibrary;
import com.sedmelluq.discord.lavaplayer.tools.io.BitStreamWriter;
import com.sedmelluq.discord.lavaplayer.tools.io.ByteBufferOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class AacDecoder
extends NativeResourceHolder {
    private static final int TRANSPORT_NONE = 0;
    public static final int AAC_LC = 2;
    private final AacDecoderLibrary library = AacDecoderLibrary.getInstance();
    private final long instance = this.library.create(0);

    public void configure(int objectType, int frequency, int channels) {
        long buffer = AacDecoder.encodeConfiguration(objectType, frequency, channels);
        this.configureRaw(buffer);
    }

    public void configure(byte[] config) {
        if (config.length > 8) {
            throw new IllegalArgumentException("Cannot process a header larger than size 8");
        }
        long buffer = 0L;
        for (int i = 0; i < config.length; ++i) {
            buffer |= (long)(config[i] << (i << 3));
        }
        this.configureRaw(buffer);
    }

    private synchronized void configureRaw(long buffer) {
        int error;
        this.checkNotReleased();
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            buffer = Long.reverseBytes(buffer);
        }
        if ((error = this.library.configure(this.instance, buffer)) != 0) {
            throw new IllegalStateException("Configuring failed with error " + error);
        }
    }

    private static long encodeConfiguration(int objectType, int frequency, int channels) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.order(ByteOrder.nativeOrder());
            BitStreamWriter bitWriter = new BitStreamWriter(new ByteBufferOutputStream(buffer));
            bitWriter.write(objectType, 5);
            int frequencyIndex = AacDecoder.getFrequencyIndex(frequency);
            bitWriter.write(frequencyIndex, 4);
            if (frequencyIndex == 15) {
                bitWriter.write(frequency, 24);
            }
            bitWriter.write(channels, 4);
            bitWriter.flush();
            buffer.clear();
            return buffer.getLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getFrequencyIndex(int frequency) {
        switch (frequency) {
            case 96000: {
                return 0;
            }
            case 88200: {
                return 1;
            }
            case 64000: {
                return 2;
            }
            case 48000: {
                return 3;
            }
            case 44100: {
                return 4;
            }
            case 32000: {
                return 5;
            }
            case 24000: {
                return 6;
            }
            case 22050: {
                return 7;
            }
            case 16000: {
                return 8;
            }
            case 12000: {
                return 9;
            }
            case 11025: {
                return 10;
            }
            case 8000: {
                return 11;
            }
            case 7350: {
                return 12;
            }
        }
        return 15;
    }

    public synchronized int fill(ByteBuffer buffer) {
        this.checkNotReleased();
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Buffer argument must be a direct buffer.");
        }
        int readBytes = this.library.fill(this.instance, buffer, buffer.position(), buffer.limit());
        if (readBytes < 0) {
            throw new IllegalStateException("Filling decoder failed with error " + -readBytes);
        }
        buffer.position(buffer.position() + readBytes);
        return readBytes;
    }

    public synchronized boolean decode(ShortBuffer buffer, boolean flush) {
        this.checkNotReleased();
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Buffer argument must be a direct buffer.");
        }
        int result = this.library.decode(this.instance, buffer, buffer.capacity(), flush);
        if (result != 0 && result != 4098) {
            throw new IllegalStateException("Error from decoder " + result);
        }
        return result == 0;
    }

    @Override
    protected void freeResources() {
        this.library.destroy(this.instance);
    }
}

