/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OggContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(OggContainerProbe.class);

    @Override
    public String getName() {
        return "ogg";
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream stream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(stream, OggPacketInputStream.OGG_PAGE_HEADER)) {
            return null;
        }
        log.debug("Track {} is an OGG stream.", (Object)reference.identifier);
        return new MediaContainerDetectionResult((MediaContainerProbe)this, new AudioTrackInfo(reference.title != null ? reference.title : "Unknown title", "Unknown artist", Long.MAX_VALUE, reference.identifier, true));
    }

    @Override
    public AudioTrack createTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new OggAudioTrack(trackInfo, inputStream);
    }
}

