/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.mp3;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3FrameReader;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3TrackProvider;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mp3ContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(Mp3ContainerProbe.class);
    private static final int[] ID3_TAG = new int[]{73, 68, 51};
    private static final String TITLE_TAG = "TIT2";
    private static final String ARTIST_TAG = "TPE1";

    @Override
    public String getName() {
        return "mp3";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, ID3_TAG)) {
            byte[] frameHeader = new byte[4];
            Mp3FrameReader frameReader = new Mp3FrameReader(inputStream, frameHeader);
            if (!frameReader.scanForFrame(1000, false)) {
                return null;
            }
            inputStream.seek(0L);
        }
        log.debug("Track {} is an MP3 file.", (Object)reference.identifier);
        try (Mp3TrackProvider file = new Mp3TrackProvider(null, inputStream);){
            file.parseHeaders();
            MediaContainerDetectionResult mediaContainerDetectionResult = new MediaContainerDetectionResult((MediaContainerProbe)this, new AudioTrackInfo(DataFormatTools.defaultOnNull(file.getIdv3Tag(TITLE_TAG), reference.title != null ? reference.title : "Unknown title"), DataFormatTools.defaultOnNull(file.getIdv3Tag(ARTIST_TAG), "Unknown artist"), file.getDuration(), reference.identifier, !file.isSeekable()));
            return mediaContainerDetectionResult;
        }
    }

    @Override
    public AudioTrack createTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new Mp3AudioTrack(trackInfo, inputStream);
    }
}

