/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.matroska;

import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFileTrack;
import com.sedmelluq.discord.lavaplayer.filter.FilterChainBuilder;
import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.natives.vorbis.VorbisDecoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.nio.ByteBuffer;

public class MatroskaVorbisTrackConsumer
implements MatroskaTrackConsumer {
    private static final int PCM_BUFFER_SIZE = 4096;
    private static final int COPY_BUFFER_SIZE = 256;
    private final MatroskaFileTrack track;
    private final VorbisDecoder decoder;
    private final byte[] copyBuffer;
    private final FloatPcmAudioFilter downstream;
    private ByteBuffer inputBuffer;
    private float[][] channelPcmBuffers;

    public MatroskaVorbisTrackConsumer(AudioProcessingContext context, MatroskaFileTrack track) {
        this.track = track;
        this.decoder = new VorbisDecoder();
        this.copyBuffer = new byte[256];
        MatroskaFileTrack.AudioDetails audioTrack = track.audio;
        this.downstream = FilterChainBuilder.forFloatPcm(context, audioTrack.channels, (int)audioTrack.samplingFrequency);
    }

    @Override
    public MatroskaFileTrack getTrack() {
        return this.track;
    }

    @Override
    public void initialise() {
        ByteBuffer directPrivateData = ByteBuffer.allocateDirect(this.track.codecPrivate.length);
        directPrivateData.put(this.track.codecPrivate);
        directPrivateData.flip();
        try {
            byte lengthInfoSize = directPrivateData.get();
            if (lengthInfoSize != 2) {
                throw new IllegalStateException("Unexpected lacing count.");
            }
            int firstHeaderSize = this.readLacingValue(directPrivateData);
            int secondHeaderSize = this.readLacingValue(directPrivateData);
            this.decoder.parseHeader(directPrivateData, firstHeaderSize, true);
            this.decoder.parseHeader(directPrivateData, secondHeaderSize, false);
            this.decoder.parseHeader(directPrivateData, directPrivateData.remaining(), false);
            this.decoder.initialise();
            this.channelPcmBuffers = new float[this.decoder.getChannelCount()][];
            for (int i = 0; i < this.channelPcmBuffers.length; ++i) {
                this.channelPcmBuffers[i] = new float[4096];
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Reading Vorbis header failed.", e);
        }
    }

    private int readLacingValue(ByteBuffer buffer) {
        int current;
        int value = 0;
        do {
            current = buffer.get() & 0xFF;
            value += current;
        } while (current == 255);
        return value;
    }

    @Override
    public void seekPerformed(long requestedTimecode, long providedTimecode) {
        this.downstream.seekPerformed(requestedTimecode, providedTimecode);
    }

    @Override
    public void flush() throws InterruptedException {
        this.downstream.flush();
    }

    private ByteBuffer getDirectBuffer(int size) {
        if (this.inputBuffer == null || this.inputBuffer.capacity() < size) {
            this.inputBuffer = ByteBuffer.allocateDirect(size * 3 / 2);
        }
        this.inputBuffer.clear();
        return this.inputBuffer;
    }

    private ByteBuffer getAsDirectBuffer(ByteBuffer data) {
        ByteBuffer buffer = this.getDirectBuffer(data.remaining());
        while (data.remaining() > 0) {
            int chunk = Math.min(this.copyBuffer.length, data.remaining());
            data.get(this.copyBuffer, 0, chunk);
            buffer.put(this.copyBuffer, 0, chunk);
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public void consume(ByteBuffer data) throws InterruptedException {
        int output;
        ByteBuffer directBuffer = this.getAsDirectBuffer(data);
        this.decoder.input(directBuffer);
        do {
            if ((output = this.decoder.output(this.channelPcmBuffers)) <= 0) continue;
            this.downstream.process(this.channelPcmBuffers, 0, output);
        } while (output == 4096);
    }

    @Override
    public void close() {
        this.downstream.close();
        this.decoder.close();
    }
}

