/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.message.react.MessageReactionRemoveAllEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONObject;

public class MessageReactionBulkRemoveHandler
extends SocketHandler {
    public MessageReactionBulkRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String messageId = content.getString("message_id");
        String channelId = content.getString("channel_id");
        MessageChannel channel = this.api.getTextChannelById(channelId);
        if (channel == null) {
            channel = this.api.getPrivateChannelById(channelId);
        }
        if (channel == null && this.api.getAccountType() == AccountType.CLIENT) {
            channel = this.api.asClient().getGroupById(channelId);
        }
        if (channel == null) {
            channel = this.api.getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            EventCache.get(this.api).cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a reaction for a channel that JDA does not currently have cached");
            return null;
        }
        this.api.getEventManager().handle(new MessageReactionRemoveAllEvent(this.api, this.responseNumber, messageId, channel));
        return null;
    }
}

