/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import net.dv8tion.jda.core.utils.IOUtil;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.http.util.Args;

public class Icon {
    protected final String encoding;

    protected Icon(String base64Encoding) {
        this.encoding = "data:image/jpeg;base64," + base64Encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static Icon from(File file) throws IOException {
        Args.notNull(file, "Provided File");
        Args.check(file.exists(), "Provided file does not exist!");
        return Icon.from(IOUtil.readFully(file));
    }

    public static Icon from(InputStream stream) throws IOException {
        Args.notNull(stream, "InputStream");
        return Icon.from(IOUtil.readFully(stream));
    }

    public static Icon from(byte[] data) {
        Args.notNull(data, "Provided byte[]");
        String encoding = StringUtils.newStringUtf8(Base64.getEncoder().encode(data));
        return new Icon(encoding);
    }
}

