/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingFormatArgumentException;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.IMentionable;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.MessageImpl;

public class MessageBuilder {
    public static final String USER_KEY = "%U%";
    public static final String ROLE_KEY = "%R%";
    public static final String TEXTCHANNEL_KEY = "%TC%";
    public static final String EVERYONE_KEY = "%E%";
    public static final String HERE_KEY = "%H%";
    public static final IMentionable EVERYONE_MENTION = () -> "@everyone";
    public static final IMentionable HERE_MENTION = () -> "@here";
    protected static final Pattern FORMAT_PATTERN = Pattern.compile(String.format("%s|%s|%s|%s|%s", "%U%", "%R%", "%TC%", "%E%", "%H%"));
    protected static final Pattern USER_MENTION_PATTERN = Pattern.compile("<@!{0,1}([0-9]+)>");
    protected static final Pattern CHANNEL_MENTION_PATTERN = Pattern.compile("<#!{0,1}([0-9]+)>");
    protected static final Pattern ROLE_MENTION_PATTERN = Pattern.compile("<@&!{0,1}([0-9]+)>");
    protected final StringBuilder builder = new StringBuilder();
    protected boolean isTTS = false;
    protected MessageEmbed embed;

    public MessageBuilder setTTS(boolean tts) {
        this.isTTS = tts;
        return this;
    }

    public MessageBuilder setEmbed(MessageEmbed embed) {
        this.embed = embed;
        return this;
    }

    @Deprecated
    public MessageBuilder appendString(CharSequence text) {
        return this.append(text);
    }

    public MessageBuilder append(CharSequence text) {
        this.builder.append(text);
        return this;
    }

    public MessageBuilder append(Object object) {
        return this.append(String.valueOf(object));
    }

    public MessageBuilder append(IMentionable mention) {
        this.builder.append(mention.getAsMention());
        return this;
    }

    public MessageBuilder append(CharSequence text, Formatting ... format) {
        boolean blockPresent = false;
        for (Formatting formatting : format) {
            if (formatting == Formatting.BLOCK) {
                blockPresent = true;
                continue;
            }
            this.builder.append(formatting.getTag());
        }
        if (blockPresent) {
            this.builder.append(Formatting.BLOCK.getTag());
        }
        this.builder.append(text);
        if (blockPresent) {
            this.builder.append(Formatting.BLOCK.getTag());
        }
        for (int i = format.length - 1; i >= 0; --i) {
            if (format[i] == Formatting.BLOCK) continue;
            this.builder.append(format[i].getTag());
        }
        return this;
    }

    @Deprecated
    public MessageBuilder appendString(CharSequence text, Formatting ... format) {
        return this.append(text, format);
    }

    public MessageBuilder appendFormat(String format, Object ... args) {
        if (format == null || format.isEmpty()) {
            return this;
        }
        int index = 0;
        int stringIndex = 0;
        StringBuilder sb = new StringBuilder();
        Matcher m = FORMAT_PATTERN.matcher(format);
        List<Class> classes = Arrays.asList(User.class, TextChannel.class, Role.class);
        while (m.find() && stringIndex < format.length()) {
            Class target = null;
            boolean everyone = false;
            switch (m.group()) {
                case "%U%": {
                    target = User.class;
                    break;
                }
                case "%TC%": {
                    target = TextChannel.class;
                    break;
                }
                case "%R%": {
                    target = Role.class;
                    break;
                }
                case "%E%": {
                    everyone = true;
                    break;
                }
                case "%H%": {
                    everyone = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("MessageBuilder's format regex triggered on an unknown key. How?!");
                }
            }
            sb.append(format.substring(stringIndex, m.start())).append("%s");
            stringIndex = m.end();
            if (target != null) {
                boolean found = false;
                for (int i = index; i < args.length; ++i) {
                    Object arg = args[i];
                    if (classes.stream().anyMatch(c -> c.isInstance(arg))) {
                        if (!target.isInstance(arg)) {
                            throw new IllegalArgumentException(String.format("Expected: %s at args index: %d but received: %s instead", target.getSimpleName(), index, arg.getClass().getSimpleName()));
                        }
                        if (arg instanceof User) {
                            User u = (User)arg;
                            args[i] = u.getAsMention();
                        } else if (arg instanceof TextChannel) {
                            TextChannel tc = (TextChannel)arg;
                            args[i] = tc.getAsMention();
                        } else if (arg instanceof Role) {
                            Role r = (Role)arg;
                            args[i] = r.getAsMention();
                        } else {
                            throw new IllegalArgumentException("When checking instances of arguments, something failed. Contact dev.");
                        }
                        ++index;
                        found = true;
                        break;
                    }
                    ++index;
                }
                if (found) continue;
                throw new MissingFormatArgumentException(m.group());
            }
            if (everyone) {
                sb.append("@everyone");
                continue;
            }
            sb.append("@here");
        }
        if (stringIndex < format.length()) {
            sb.append(format.substring(stringIndex, format.length()));
        }
        String finalFormat = String.format(sb.toString(), args);
        this.builder.append(finalFormat);
        return this;
    }

    public MessageBuilder appendCodeBlock(CharSequence text, CharSequence language) {
        this.builder.append("```").append(language).append('\n').append(text).append("\n```");
        return this;
    }

    @Deprecated
    public MessageBuilder appendMention(User user) {
        return this.append(user);
    }

    @Deprecated
    public MessageBuilder appendEveryoneMention() {
        return this.append(EVERYONE_MENTION);
    }

    @Deprecated
    public MessageBuilder appendHereMention() {
        return this.append(HERE_MENTION);
    }

    @Deprecated
    public MessageBuilder appendMention(TextChannel channel) {
        return this.append(channel);
    }

    @Deprecated
    public MessageBuilder appendMention(Role role) {
        return this.append(role);
    }

    public int length() {
        return this.builder.length();
    }

    public boolean isEmpty() {
        return this.builder.length() == 0 && this.embed == null;
    }

    public Message build() {
        String message = this.builder.toString();
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("Cannot build a Message with no content. (You never added any content to the message)");
        }
        if (message.length() > 2000) {
            throw new UnsupportedOperationException("Cannot build a Message with more than 2000 characters. Please limit your input.");
        }
        return new MessageImpl("", null, false).setContent(message).setTTS(this.isTTS).setEmbeds(this.embed == null ? new LinkedList() : Collections.singletonList(this.embed));
    }

    public MessageBuilder replaceAll(String target, String replacement) {
        int index;
        while ((index = this.builder.indexOf(target)) != -1) {
            this.builder.replace(index, index + target.length(), replacement);
        }
        return this;
    }

    public MessageBuilder replaceFirst(String target, String replacement) {
        int index = this.builder.indexOf(target);
        if (index != -1) {
            this.builder.replace(index, index + target.length(), replacement);
        }
        return this;
    }

    public MessageBuilder replaceLast(String target, String replacement) {
        int index = this.builder.lastIndexOf(target);
        if (index != -1) {
            this.builder.replace(index, index + target.length(), replacement);
        }
        return this;
    }

    public MessageBuilder stripMentions(JDA jda) {
        return this.stripMentions(jda, (Guild)null, MentionType.EVERYONE, MentionType.HERE, MentionType.CHANNEL, MentionType.ROLE, MentionType.USER);
    }

    public MessageBuilder stripMentions(Guild guild) {
        return this.stripMentions(guild.getJDA(), guild, MentionType.EVERYONE, MentionType.HERE, MentionType.CHANNEL, MentionType.ROLE, MentionType.USER);
    }

    public MessageBuilder stripMentions(Guild guild, MentionType ... types) {
        return this.stripMentions(guild.getJDA(), guild, types);
    }

    public MessageBuilder stripMentions(JDA jda, MentionType ... types) {
        return this.stripMentions(jda, (Guild)null, types);
    }

    private MessageBuilder stripMentions(JDA jda, Guild guild, MentionType ... types) {
        if (types == null) {
            return this;
        }
        String string = null;
        block7: for (MentionType mention : types) {
            if (mention == null) continue;
            switch (mention) {
                case EVERYONE: {
                    this.replaceAll("@everyone", "@\u0435veryone");
                    continue block7;
                }
                case HERE: {
                    this.replaceAll("@here", "@h\u0435re");
                    continue block7;
                }
                case CHANNEL: {
                    if (string == null) {
                        string = this.builder.toString();
                    }
                    Matcher matcher = CHANNEL_MENTION_PATTERN.matcher(string);
                    while (matcher.find()) {
                        TextChannel channel = jda.getTextChannelById(matcher.group(1));
                        if (channel == null) continue;
                        this.replaceAll(matcher.group(), "#" + channel.getName());
                    }
                    continue block7;
                }
                case ROLE: {
                    if (string == null) {
                        string = this.builder.toString();
                    }
                    Matcher matcher = ROLE_MENTION_PATTERN.matcher(string);
                    block9: while (matcher.find()) {
                        for (Guild g : jda.getGuilds()) {
                            Role role = g.getRoleById(matcher.group(1));
                            if (role == null) continue;
                            this.replaceAll(matcher.group(), "@" + role.getName());
                            continue block9;
                        }
                    }
                    continue block7;
                }
                case USER: {
                    if (string == null) {
                        string = this.builder.toString();
                    }
                    Matcher matcher = USER_MENTION_PATTERN.matcher(string);
                    while (matcher.find()) {
                        Member member;
                        User user = jda.getUserById(matcher.group(1));
                        String replacement = null;
                        if (user == null) continue;
                        replacement = guild != null && (member = guild.getMember(user)) != null ? member.getEffectiveName() : user.getName();
                        this.replaceAll(matcher.group(), "@" + replacement);
                    }
                    continue block7;
                }
            }
        }
        return this;
    }

    public StringBuilder getStringBuilder() {
        return this.builder;
    }

    public int indexOf(CharSequence target, int fromIndex, int endIndex) {
        int targetCount;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("index out of range: " + fromIndex);
        }
        if (endIndex < 0) {
            throw new IndexOutOfBoundsException("index out of range: " + endIndex);
        }
        if (fromIndex > this.length()) {
            throw new IndexOutOfBoundsException("fromIndex > length()");
        }
        if (fromIndex > endIndex) {
            throw new IndexOutOfBoundsException("fromIndex > endIndex");
        }
        if (endIndex >= this.builder.length()) {
            endIndex = this.builder.length() - 1;
        }
        if ((targetCount = target.length()) == 0) {
            return fromIndex;
        }
        char strFirstChar = target.charAt(0);
        int max = endIndex + targetCount - 1;
        block0: for (int i = fromIndex; i <= max; ++i) {
            if (this.builder.charAt(i) != strFirstChar) continue;
            for (int j = 1; j < targetCount; ++j) {
                if (this.builder.charAt(i + j) != target.charAt(j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int lastIndexOf(CharSequence target, int fromIndex, int endIndex) {
        int targetCount;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("index out of range: " + fromIndex);
        }
        if (endIndex < 0) {
            throw new IndexOutOfBoundsException("index out of range: " + endIndex);
        }
        if (fromIndex > this.length()) {
            throw new IndexOutOfBoundsException("fromIndex > length()");
        }
        if (fromIndex > endIndex) {
            throw new IndexOutOfBoundsException("fromIndex > endIndex");
        }
        if (endIndex >= this.builder.length()) {
            endIndex = this.builder.length() - 1;
        }
        if ((targetCount = target.length()) == 0) {
            return endIndex;
        }
        int rightIndex = endIndex - targetCount;
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        int strLastIndex = targetCount - 1;
        char strLastChar = target.charAt(strLastIndex);
        int min = fromIndex + targetCount - 1;
        block0: for (int i = endIndex; i >= min; --i) {
            if (this.builder.charAt(i) != strLastChar) continue;
            int j = strLastIndex - 1;
            int k = 1;
            while (j >= 0) {
                if (this.builder.charAt(i - k) != target.charAt(j)) continue block0;
                --j;
                ++k;
            }
            return i - target.length() + 1;
        }
        return -1;
    }

    public Queue<Message> buildAll(SplitPolicy ... policy) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("Cannot build a Message with no content. (You never added any content to the message)");
        }
        LinkedList<Message> messages = new LinkedList<Message>();
        if (this.builder.length() <= 2000) {
            messages.add(this.build());
            return messages;
        }
        if (policy == null || policy.length == 0) {
            policy = new SplitPolicy[]{SplitPolicy.ANYWHERE};
        }
        int currentBeginIndex = 0;
        block0: while (currentBeginIndex < this.builder.length() - 2001) {
            for (int i = 0; i < policy.length; ++i) {
                int currentEndIndex = policy[i].nextMessage(currentBeginIndex, this);
                if (currentEndIndex == -1) continue;
                messages.add(this.build(currentBeginIndex, currentEndIndex));
                currentBeginIndex = currentEndIndex;
                continue block0;
            }
            throw new RuntimeException("failed to split the messages");
        }
        if (currentBeginIndex < this.builder.length() - 1) {
            messages.add(this.build(currentBeginIndex, this.builder.length() - 1));
        }
        if (this.embed != null) {
            ((MessageImpl)messages.get(messages.size() - 1)).setEmbeds(Collections.singletonList(this.embed));
        }
        return messages;
    }

    protected Message build(int beginIndex, int endIndex) {
        return new MessageImpl("", null, false).setContent(this.builder.substring(beginIndex, endIndex)).setTTS(this.isTTS);
    }

    public static enum Formatting {
        ITALICS("*"),
        BOLD("**"),
        STRIKETHROUGH("~~"),
        UNDERLINE("__"),
        BLOCK("`");

        private final String tag;

        private Formatting(String tag) {
            this.tag = tag;
        }

        private String getTag() {
            return this.tag;
        }
    }

    public static enum MentionType {
        EVERYONE,
        HERE,
        USER,
        CHANNEL,
        ROLE;

    }

    public static interface SplitPolicy {
        public static final SplitPolicy NEWLINE = new CharSequenceSplitPolicy("\n", true);
        public static final SplitPolicy SPACE = new CharSequenceSplitPolicy(" ", true);
        public static final SplitPolicy ANYWHERE = (i, b) -> Math.min(i + 2000, b.length());

        public static SplitPolicy onChars(CharSequence chars, boolean remove) {
            return new CharSequenceSplitPolicy(chars, remove);
        }

        public int nextMessage(int var1, MessageBuilder var2);

        public static class CharSequenceSplitPolicy
        implements SplitPolicy {
            private final boolean remove;
            private final CharSequence chars;

            private CharSequenceSplitPolicy(CharSequence chars, boolean remove) {
                this.chars = chars;
                this.remove = remove;
            }

            @Override
            public int nextMessage(int currentBeginIndex, MessageBuilder builder) {
                int currentEndIndex = builder.lastIndexOf(this.chars, currentBeginIndex, currentBeginIndex + 2000 - (this.remove ? this.chars.length() : 0));
                if (currentEndIndex < 0) {
                    return -1;
                }
                return currentEndIndex + this.chars.length();
            }
        }
    }
}

