/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.util;

import ch.njol.skript.Skript;
import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManagers;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.iblitzkriegi.vixio.util.GuildMusicManager;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.managers.AudioManager;

public class VixioAudioHandlers {
    public static AudioPlayerManager playerManager;
    public static Map<Long, GuildMusicManager> musicManagers;

    public VixioAudioHandlers() {
        musicManagers = new HashMap<Long, GuildMusicManager>();
        playerManager = new DefaultAudioPlayerManager();
        AudioSourceManagers.registerRemoteSources(playerManager);
        AudioSourceManagers.registerLocalSource(playerManager);
    }

    public static synchronized GuildMusicManager getGuildAudioPlayer(Guild guild) {
        long guildId = Long.parseLong(guild.getId());
        GuildMusicManager musicManager = musicManagers.get(guildId);
        if (musicManager == null) {
            musicManager = new GuildMusicManager(playerManager);
            musicManagers.put(guildId, musicManager);
        }
        guild.getAudioManager().setSendingHandler(musicManager.getSendHandler());
        return musicManager;
    }

    public static void loadAndPlay(VoiceChannel channel, String trackUrl) {
        final GuildMusicManager musicManager = VixioAudioHandlers.getGuildAudioPlayer(channel.getGuild());
        Skript.warning((String)"Here");
        playerManager.loadItemOrdered(musicManager, trackUrl, new AudioLoadResultHandler(){

            @Override
            public void trackLoaded(AudioTrack track) {
                Skript.warning((String)"Here2");
                musicManager.scheduler.queue(track);
                musicManager.player.playTrack(track);
            }

            @Override
            public void playlistLoaded(AudioPlaylist playlist) {
                AudioTrack firstTrack = playlist.getSelectedTrack();
                if (firstTrack == null) {
                    firstTrack = playlist.getTracks().get(0);
                }
                Skript.warning((String)"Here");
                musicManager.scheduler.queue(firstTrack);
                musicManager.player.playTrack(firstTrack);
            }

            @Override
            public void noMatches() {
                Skript.warning((String)"Noting found by that Audio link.");
            }

            @Override
            public void loadFailed(FriendlyException exception) {
                Skript.warning((String)"Could not load Audio from the provided link.");
            }
        });
    }

    public static void play(Guild guild, GuildMusicManager musicManager, AudioTrack track) {
        VixioAudioHandlers.connectToFirstVoiceChannel(guild.getAudioManager());
        musicManager.scheduler.queue(track);
    }

    public static void skipTrack(TextChannel channel) {
        GuildMusicManager musicManager = VixioAudioHandlers.getGuildAudioPlayer(channel.getGuild());
        musicManager.scheduler.nextTrack();
        channel.sendMessage("Skipped to next track.").queue();
    }

    public static void connectToFirstVoiceChannel(AudioManager audioManager) {
        block0: {
            Iterator<VoiceChannel> iterator;
            if (audioManager.isConnected() || audioManager.isAttemptingToConnect() || !(iterator = audioManager.getGuild().getVoiceChannels().iterator()).hasNext()) break block0;
            VoiceChannel voiceChannel = iterator.next();
            audioManager.openAudioConnection(voiceChannel);
        }
    }
}

