/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.track.playback;

import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameConsumer;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameProvider;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameRebuilder;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioFrameBuffer
implements AudioFrameConsumer,
AudioFrameProvider {
    private static final Logger log = LoggerFactory.getLogger(AudioFrameBuffer.class);
    private static final byte[] SILENT_OPUS_FRAME = new byte[]{-4, -1, -2};
    private final Object synchronizer = new Object();
    private final int fullCapacity;
    private final ArrayBlockingQueue<AudioFrame> audioFrames;
    private volatile boolean locked;
    private volatile boolean receivedFrames;
    private boolean terminated;
    private boolean terminateOnEmpty;
    private boolean clearOnInsert;

    public AudioFrameBuffer(int bufferDuration) {
        this.fullCapacity = bufferDuration / 20 + 1;
        this.audioFrames = new ArrayBlockingQueue(this.fullCapacity);
        this.terminated = false;
        this.terminateOnEmpty = false;
        this.clearOnInsert = false;
        this.receivedFrames = false;
    }

    @Override
    public void consume(AudioFrame frame) throws InterruptedException {
        if (!this.locked) {
            this.receivedFrames = true;
            if (this.clearOnInsert) {
                this.audioFrames.clear();
                this.clearOnInsert = false;
            }
            this.audioFrames.put(frame);
        }
    }

    public int getRemainingCapacity() {
        return this.audioFrames.remainingCapacity();
    }

    public int getFullCapacity() {
        return this.fullCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTermination() throws InterruptedException {
        Object object = this.synchronizer;
        synchronized (object) {
            while (!this.terminated) {
                this.synchronizer.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFrame provide() {
        AudioFrame frame = this.audioFrames.poll();
        if (frame == null) {
            Object object = this.synchronizer;
            synchronized (object) {
                if (this.terminateOnEmpty) {
                    this.terminateOnEmpty = false;
                    this.terminated = true;
                    this.synchronizer.notifyAll();
                    return AudioFrame.TERMINATOR;
                }
            }
        } else if (frame.volume == 0) {
            return new AudioFrame(frame.timecode, SILENT_OPUS_FRAME, 0);
        }
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerminateOnEmpty() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.clearOnInsert) {
                this.audioFrames.clear();
                this.clearOnInsert = false;
            }
            if (!this.terminated) {
                this.terminateOnEmpty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClearOnInsert() {
        Object object = this.synchronizer;
        synchronized (object) {
            this.clearOnInsert = true;
            this.terminateOnEmpty = false;
        }
    }

    public boolean hasClearOnInsert() {
        return this.clearOnInsert;
    }

    public void clear() {
        this.audioFrames.clear();
    }

    public void lockBuffer() {
        this.locked = true;
    }

    public boolean hasReceivedFrames() {
        return this.receivedFrames;
    }

    @Override
    public void rebuild(AudioFrameRebuilder rebuilder) {
        ArrayList frames = new ArrayList();
        int frameCount = this.audioFrames.drainTo(frames);
        log.debug("Running rebuilder {} on {} buffered frames.", (Object)rebuilder.getClass().getSimpleName(), (Object)frameCount);
        for (AudioFrame frame : frames) {
            this.audioFrames.add(rebuilder.rebuild(frame));
        }
    }
}

