/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.twitch;

import com.sedmelluq.discord.lavaplayer.container.adts.AdtsAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpegts.MpegTsElementaryInputStream;
import com.sedmelluq.discord.lavaplayer.container.mpegts.PesPacketInputStream;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamSegmentUrlProvider;
import com.sedmelluq.discord.lavaplayer.tools.io.ChainedInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchStreamAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(TwitchStreamAudioTrack.class);
    private final TwitchStreamAudioSourceManager sourceManager;
    private final String channelName;
    private final TwitchStreamSegmentUrlProvider segmentUrlProvider;

    public TwitchStreamAudioTrack(AudioTrackInfo trackInfo, TwitchStreamAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
        this.channelName = TwitchStreamAudioSourceManager.getChannelIdentifierFromUrl(trackInfo.identifier);
        this.segmentUrlProvider = new TwitchStreamSegmentUrlProvider(this.channelName);
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        log.debug("Starting to play Twitch channel {}.", (Object)this.channelName);
        try (CloseableHttpClient httpClient = this.sourceManager.createHttpClient();
             ChainedInputStream chainedInputStream = new ChainedInputStream(() -> this.getSegmentInputStream(httpClient));){
            MpegTsElementaryInputStream elementaryInputStream = new MpegTsElementaryInputStream(chainedInputStream, 15);
            PesPacketInputStream pesPacketInputStream = new PesPacketInputStream(elementaryInputStream);
            this.processDelegate(new AdtsAudioTrack(this.trackInfo, pesPacketInputStream), localExecutor);
        }
    }

    private InputStream getSegmentInputStream(CloseableHttpClient httpClient) {
        String url = this.segmentUrlProvider.getNextSegmentUrl(httpClient);
        if (url == null) {
            return null;
        }
        CloseableHttpResponse response = null;
        boolean success = false;
        try {
            response = httpClient.execute(TwitchStreamAudioSourceManager.createGetRequest(url));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Invalid status code " + statusCode + " from segment data URL.");
            }
            success = true;
            InputStream inputStream = response.getEntity().getContent();
            return inputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (response != null && !success) {
                IOUtils.closeQuietly((Closeable)response);
            }
        }
    }

    @Override
    public AudioTrack makeClone() {
        return new TwitchStreamAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

