/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.twitch;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtendedM3uParser {
    private static final Pattern directiveArgumentPattern = Pattern.compile("([A-Z-]+)=(?:\"([^\"]*)\"|[^,]*)(?:,|\\z)");

    public static Line parseLine(String line) {
        String trimmed = line.trim();
        if (trimmed.isEmpty()) {
            return Line.EMPTY_LINE;
        }
        if (!trimmed.startsWith("#")) {
            return new Line(trimmed, null, null);
        }
        return ExtendedM3uParser.parseDirectiveLine(trimmed);
    }

    private static Line parseDirectiveLine(String line) {
        String[] parts = line.split(":", 2);
        if (parts.length == 1) {
            return new Line(null, line.substring(1), Collections.emptyMap());
        }
        Matcher matcher = directiveArgumentPattern.matcher(parts[1]);
        HashMap<String, String> arguments = new HashMap<String, String>();
        while (matcher.find()) {
            arguments.put(matcher.group(1), matcher.group(2));
        }
        return new Line(null, parts[0].substring(1), arguments);
    }

    public static class Line {
        private static final Line EMPTY_LINE = new Line(null, null, null);
        public final String lineData;
        public final String directiveName;
        public final Map<String, String> directiveArguments;

        private Line(String lineData, String directiveName, Map<String, String> directiveArguments) {
            this.lineData = lineData;
            this.directiveName = directiveName;
            this.directiveArguments = directiveArguments;
        }

        public boolean isDirective() {
            return this.directiveName != null;
        }

        public boolean isData() {
            return this.lineData != null;
        }
    }
}

