/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.local;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.local.LocalAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.local.LocalSeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.File;

public class LocalAudioTrack
extends DelegatedAudioTrack {
    private final File file;
    private final MediaContainerProbe probe;
    private final LocalAudioSourceManager sourceManager;

    public LocalAudioTrack(AudioTrackInfo trackInfo, MediaContainerProbe probe, LocalAudioSourceManager sourceManager) {
        super(trackInfo);
        this.file = new File(trackInfo.identifier);
        this.probe = probe;
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (LocalSeekableInputStream inputStream = new LocalSeekableInputStream(this.file);){
            this.processDelegate((InternalAudioTrack)this.probe.createTrack(this.trackInfo, inputStream), localExecutor);
        }
    }

    @Override
    public AudioTrack makeClone() {
        return new LocalAudioTrack(this.trackInfo, this.probe, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

