/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.remote;

import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import com.sedmelluq.discord.lavaplayer.remote.RemoteNodeManager;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackState;
import com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerTracker;
import com.sedmelluq.discord.lavaplayer.track.TrackStateListener;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameBuffer;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAudioTrackExecutor
implements AudioTrackExecutor {
    private static final Logger log = LoggerFactory.getLogger(RemoteAudioTrackExecutor.class);
    private static final long NO_SEEK = -1L;
    private static final int BUFFER_DURATION_MS = 3000;
    private final AudioTrack track;
    private final AudioConfiguration configuration;
    private final RemoteNodeManager remoteNodeManager;
    private final AtomicInteger volumeLevel;
    private final long executorId;
    private final AudioFrameBuffer frameBuffer = new AudioFrameBuffer(3000);
    private final AtomicLong lastFrameTimecode = new AtomicLong();
    private final AtomicLong pendingSeek = new AtomicLong(-1L);
    private final TrackMarkerTracker markerTracker = new TrackMarkerTracker();
    private volatile TrackStateListener activeListener;
    private volatile boolean hasReceivedData;
    private volatile boolean hasStarted;
    private volatile Throwable trackException;

    public RemoteAudioTrackExecutor(AudioTrack track, AudioConfiguration configuration, RemoteNodeManager remoteNodeManager, AtomicInteger volumeLevel) {
        this.track = track;
        this.configuration = configuration;
        this.remoteNodeManager = remoteNodeManager;
        this.volumeLevel = volumeLevel;
        this.executorId = System.nanoTime();
    }

    public long getExecutorId() {
        return this.executorId;
    }

    public AudioConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getVolume() {
        return this.volumeLevel.get();
    }

    public AudioTrack getTrack() {
        return this.track;
    }

    public long getPendingSeek() {
        return this.pendingSeek.get();
    }

    public void clearSeek(long position) {
        if (position != -1L) {
            this.frameBuffer.setClearOnInsert();
            if (this.pendingSeek.compareAndSet(position, -1L)) {
                this.markerTracker.checkSeekTimecode(position);
            }
        }
    }

    public void dispatchException(FriendlyException exception) {
        TrackStateListener currentListener = this.activeListener;
        ExceptionTools.log(log, exception, this.track.getIdentifier());
        if (currentListener != null) {
            this.trackException = exception;
            currentListener.onTrackException(this.track, exception);
        }
    }

    public void receivedData() {
        this.hasReceivedData = true;
    }

    public void detach() {
        this.activeListener = null;
        this.markerTracker.trigger(TrackMarkerHandler.MarkerState.ENDED);
    }

    @Override
    public AudioFrameBuffer getAudioBuffer() {
        return this.frameBuffer;
    }

    @Override
    public void execute(TrackStateListener listener) {
        try {
            this.hasStarted = true;
            this.activeListener = listener;
            this.remoteNodeManager.startPlaying(this);
        }
        catch (Throwable throwable) {
            listener.onTrackException(this.track, ExceptionTools.wrapUnfriendlyExceptions("An error occurred when trying to start track remotely.", FriendlyException.Severity.FAULT, throwable));
            ExceptionTools.rethrowErrors(throwable);
        }
    }

    @Override
    public void stop() {
        this.frameBuffer.lockBuffer();
        this.frameBuffer.setTerminateOnEmpty();
        this.frameBuffer.clear();
        this.markerTracker.trigger(TrackMarkerHandler.MarkerState.STOPPED);
        this.remoteNodeManager.onTrackEnd(null, this.track, AudioTrackEndReason.STOPPED);
    }

    @Override
    public long getPosition() {
        return this.lastFrameTimecode.get();
    }

    @Override
    public void setPosition(long timecode) {
        this.pendingSeek.set(timecode);
    }

    @Override
    public AudioTrackState getState() {
        if (this.hasStarted && this.activeListener == null) {
            return AudioTrackState.FINISHED;
        }
        if (!this.hasReceivedData) {
            return AudioTrackState.LOADING;
        }
        return AudioTrackState.PLAYING;
    }

    @Override
    public void setMarker(TrackMarker marker) {
        this.markerTracker.set(marker, this.getPosition());
    }

    @Override
    public AudioFrame provide() {
        AudioFrame frame = this.frameBuffer.provide();
        if (frame != null && !frame.isTerminator()) {
            this.lastFrameTimecode.set(frame.timecode);
            if (this.pendingSeek.get() == -1L && !this.frameBuffer.hasClearOnInsert()) {
                this.markerTracker.checkPlaybackTimecode(frame.timecode);
            }
        }
        return frame;
    }

    @Override
    public boolean failedBeforeLoad() {
        return this.trackException != null && !this.hasReceivedData;
    }
}

