/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.mpeg;

import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAacTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegFileLoader;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackInfo;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegFileTrackProvider;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BaseAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpegAudioTrack
extends BaseAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(MpegAudioTrack.class);
    private final SeekableInputStream inputStream;

    public MpegAudioTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        super(trackInfo);
        this.inputStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(LocalAudioTrackExecutor localExecutor) {
        MpegFileLoader file = new MpegFileLoader(this.inputStream);
        file.parseHeaders();
        try (MpegTrackConsumer trackConsumer = this.loadAudioTrack(file, localExecutor.getProcessingContext());){
            MpegFileTrackProvider fileReader = file.loadReader(trackConsumer);
            if (fileReader == null) {
                throw new FriendlyException("Unknown MP4 format.", FriendlyException.Severity.SUSPICIOUS, null);
            }
            this.accurateDuration.set(fileReader.getDuration());
            localExecutor.executeProcessingLoop(fileReader::provideFrames, fileReader::seekToTimecode);
        }
    }

    private MpegTrackConsumer loadAudioTrack(MpegFileLoader file, AudioProcessingContext context) {
        MpegTrackConsumer trackConsumer = null;
        boolean success = false;
        try {
            trackConsumer = this.selectAudioTrack(file.getTrackList(), context);
            if (trackConsumer == null) {
                throw new FriendlyException("The audio codec used in the track is not supported.", FriendlyException.Severity.SUSPICIOUS, null);
            }
            log.debug("Starting to play track with codec {}", (Object)trackConsumer.getTrack().codecName);
            trackConsumer.initialise();
            success = true;
            MpegTrackConsumer mpegTrackConsumer = trackConsumer;
            return mpegTrackConsumer;
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions("Something went wrong when loading an MP4 format track.", FriendlyException.Severity.FAULT, e);
        }
        finally {
            if (!success && trackConsumer != null) {
                trackConsumer.close();
            }
        }
    }

    private MpegTrackConsumer selectAudioTrack(List<MpegTrackInfo> tracks, AudioProcessingContext context) {
        for (MpegTrackInfo track : tracks) {
            if (!"soun".equals(track.handler) || !"mp4a".equals(track.codecName)) continue;
            return new MpegAacTrackConsumer(context, track);
        }
        return null;
    }
}

