/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.chatterbotapi;

import com.google.code.chatterbotapi.ChatterBot;
import com.google.code.chatterbotapi.ChatterBotSession;
import com.google.code.chatterbotapi.ChatterBotThought;
import com.google.code.chatterbotapi.Utils;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

class Cleverbot
implements ChatterBot {
    private final String baseUrl;
    private final String serviceUrl;
    private int endIndex;

    public Cleverbot(String baseUrl, String serviceUrl, int endIndex) {
        this.baseUrl = baseUrl;
        this.serviceUrl = serviceUrl;
        this.endIndex = endIndex;
    }

    @Override
    public ChatterBotSession createSession(Locale ... locales) {
        return new Session(locales);
    }

    private class Session
    implements ChatterBotSession {
        private final Map<String, String> vars = new LinkedHashMap<String, String>();
        private final Map<String, String> headers;
        private final Map<String, String> cookies;

        public Session(Locale ... locales) {
            this.vars.put("stimulus", "");
            this.vars.put("islearning", "1");
            this.vars.put("icognoid", "wsf");
            this.headers = new LinkedHashMap<String, String>();
            if (locales.length > 0) {
                this.headers.put("Accept-Language", Utils.toAcceptLanguageTags(locales));
            }
            this.cookies = new LinkedHashMap<String, String>();
            try {
                Utils.request(Cleverbot.this.baseUrl, this.headers, this.cookies, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ChatterBotThought think(ChatterBotThought thought) throws Exception {
            this.vars.put("stimulus", thought.getText());
            String formData = Utils.parametersToWWWFormURLEncoded(this.vars);
            String formDataToDigest = formData.substring(9, Cleverbot.this.endIndex);
            String formDataDigest = Utils.md5(formDataToDigest);
            this.vars.put("icognocheck", formDataDigest);
            String response = Utils.request(Cleverbot.this.serviceUrl, this.headers, this.cookies, this.vars);
            String[] responseValues = response.split("\r");
            this.vars.put("sessionid", Utils.stringAtIndex(responseValues, 1));
            this.vars.put("logurl", Utils.stringAtIndex(responseValues, 2));
            this.vars.put("vText8", Utils.stringAtIndex(responseValues, 3));
            this.vars.put("vText7", Utils.stringAtIndex(responseValues, 4));
            this.vars.put("vText6", Utils.stringAtIndex(responseValues, 5));
            this.vars.put("vText5", Utils.stringAtIndex(responseValues, 6));
            this.vars.put("vText4", Utils.stringAtIndex(responseValues, 7));
            this.vars.put("vText3", Utils.stringAtIndex(responseValues, 8));
            this.vars.put("vText2", Utils.stringAtIndex(responseValues, 9));
            this.vars.put("prevref", Utils.stringAtIndex(responseValues, 10));
            ChatterBotThought responseThought = new ChatterBotThought();
            responseThought.setText(Utils.stringAtIndex(responseValues, 0));
            return responseThought;
        }

        @Override
        public String think(String text) throws Exception {
            ChatterBotThought thought = new ChatterBotThought();
            thought.setText(text);
            return this.think(thought).getText();
        }
    }
}

