/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.nio.ByteBuffer;
import org.ebml.Element;
import org.ebml.MasterElement;
import org.ebml.io.DataWriter;
import org.ebml.matroska.MatroskaDocTypes;

public class MatroskaSegment
extends MasterElement {
    protected boolean bUnknownSize = false;

    public MatroskaSegment() {
        super(MatroskaDocTypes.Segment.getType().array());
    }

    @Override
    public long writeHeaderData(DataWriter writer) {
        byte[] size;
        long len = 0L;
        ByteBuffer type = this.getType();
        len += (long)type.remaining();
        writer.write(type);
        if (this.bUnknownSize) {
            size = new byte[5];
            size[0] = (byte)(255 >>> size.length - 1);
            for (int i = 1; i < size.length; ++i) {
                size[i] = -1;
            }
        } else {
            size = Element.makeEbmlCodedSize(this.getSize());
        }
        writer.write(ByteBuffer.wrap(size));
        return len += (long)size.length;
    }

    public void setUnknownSize(boolean bUnknownSize) {
        this.bUnknownSize = bUnknownSize;
    }

    public boolean getUnknownSize() {
        return this.bUnknownSize;
    }
}

