/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import org.ebml.MasterElement;
import org.ebml.StringElement;
import org.ebml.UnsignedIntegerElement;
import org.ebml.io.DataWriter;
import org.ebml.matroska.MatroskaCluster;
import org.ebml.matroska.MatroskaDocTypes;
import org.ebml.matroska.MatroskaFileCues;
import org.ebml.matroska.MatroskaFileFrame;
import org.ebml.matroska.MatroskaFileMetaSeek;
import org.ebml.matroska.MatroskaFileTrack;
import org.ebml.matroska.MatroskaFileTracks;
import org.ebml.matroska.MatroskaSegment;
import org.ebml.matroska.MatroskaSegmentInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaFileWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MatroskaFileWriter.class);
    protected DataWriter ioDW;
    private final MatroskaFileMetaSeek metaSeek;
    private final MatroskaFileCues cueData;
    private final MatroskaCluster cluster;
    private final MatroskaSegmentInfo segmentInfoElem;
    private final MatroskaFileTracks tracks;

    public MatroskaFileWriter(DataWriter outputDataWriter) {
        this.ioDW = outputDataWriter;
        this.writeEBMLHeader();
        this.writeSegmentHeader();
        long endOfSegmentHeader = this.ioDW.getFilePointer();
        this.metaSeek = new MatroskaFileMetaSeek(endOfSegmentHeader);
        this.cueData = new MatroskaFileCues(endOfSegmentHeader);
        this.metaSeek.write(this.ioDW);
        this.segmentInfoElem = new MatroskaSegmentInfo(this.ioDW.getFilePointer());
        this.metaSeek.addIndexedElement(MatroskaDocTypes.Info.getType(), this.ioDW.getFilePointer());
        this.segmentInfoElem.writeElement(this.ioDW);
        this.metaSeek.addIndexedElement(MatroskaDocTypes.Tracks.getType(), this.ioDW.getFilePointer());
        this.tracks = new MatroskaFileTracks(this.ioDW.getFilePointer());
        this.tracks.writeTracks(this.ioDW);
        this.cluster = new MatroskaCluster();
        this.cluster.setLimitParameters(5000L, 131072);
        this.metaSeek.addIndexedElement(MatroskaDocTypes.Cluster.getType(), this.ioDW.getFilePointer());
    }

    void writeEBMLHeader() {
        MasterElement ebmlHeaderElem = MatroskaDocTypes.EBML.getInstance();
        UnsignedIntegerElement ebmlVersionElem = MatroskaDocTypes.EBMLVersion.getInstance();
        ebmlVersionElem.setValue(1L);
        UnsignedIntegerElement ebmlReadVersionElem = MatroskaDocTypes.EBMLReadVersion.getInstance();
        ebmlReadVersionElem.setValue(1L);
        UnsignedIntegerElement ebmlMaxIdLenElem = MatroskaDocTypes.EBMLMaxIDLength.getInstance();
        ebmlMaxIdLenElem.setValue(4L);
        UnsignedIntegerElement ebmlMaxSizeLenElem = MatroskaDocTypes.EBMLMaxSizeLength.getInstance();
        ebmlMaxSizeLenElem.setValue(8L);
        StringElement docTypeElem = MatroskaDocTypes.DocType.getInstance();
        docTypeElem.setValue("matroska");
        UnsignedIntegerElement docTypeVersionElem = MatroskaDocTypes.DocTypeVersion.getInstance();
        docTypeVersionElem.setValue(3L);
        UnsignedIntegerElement docTypeReadVersionElem = MatroskaDocTypes.DocTypeReadVersion.getInstance();
        docTypeReadVersionElem.setValue(2L);
        ebmlHeaderElem.addChildElement(ebmlVersionElem);
        ebmlHeaderElem.addChildElement(ebmlReadVersionElem);
        ebmlHeaderElem.addChildElement(ebmlMaxIdLenElem);
        ebmlHeaderElem.addChildElement(ebmlMaxSizeLenElem);
        ebmlHeaderElem.addChildElement(docTypeElem);
        ebmlHeaderElem.addChildElement(docTypeVersionElem);
        ebmlHeaderElem.addChildElement(docTypeReadVersionElem);
        ebmlHeaderElem.writeElement(this.ioDW);
    }

    void writeSegmentHeader() {
        MatroskaSegment segmentElem = new MatroskaSegment();
        segmentElem.setUnknownSize(true);
        segmentElem.writeHeaderData(this.ioDW);
    }

    void writeSegmentInfo() {
        this.segmentInfoElem.update(this.ioDW);
    }

    void writeTracks() {
        this.tracks.update(this.ioDW);
    }

    public long getTimecodeScale() {
        return this.segmentInfoElem.getTimecodeScale();
    }

    public void setTimecodeScale(long timecodeScale) {
        this.segmentInfoElem.setTimecodeScale(timecodeScale);
    }

    public double getDuration() {
        return this.segmentInfoElem.getDuration();
    }

    public void setDuration(double duration) {
        this.segmentInfoElem.setDuration(duration);
    }

    public void addTrack(MatroskaFileTrack track) {
        this.tracks.addTrack(track);
    }

    public void silenceTrack(long trackNumber) {
        this.cluster.silenceTrack(trackNumber);
    }

    public void unsilenceTrack(long trackNumber) {
        this.cluster.unsilenceTrack(trackNumber);
    }

    public void addFrame(MatroskaFileFrame frame) {
        if (!this.cluster.addFrame(frame)) {
            this.flush();
        }
    }

    public void flush() {
        long clusterPos = this.ioDW.getFilePointer();
        this.cueData.addCue(clusterPos, this.cluster.getClusterTimecode(), this.cluster.getTracks());
        LOG.debug("Cluster flushing, timecode {}", (Object)this.cluster.getClusterTimecode());
        this.cluster.flush(this.ioDW);
    }

    public void close() {
        this.flush();
        this.cueData.write(this.ioDW, this.metaSeek);
        this.metaSeek.update(this.ioDW);
        this.segmentInfoElem.update(this.ioDW);
        this.tracks.update(this.ioDW);
    }
}

