/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.util.ArrayList;
import org.ebml.MasterElement;
import org.ebml.io.DataWriter;
import org.ebml.matroska.MatroskaDocTypes;
import org.ebml.matroska.MatroskaFileTrack;
import org.ebml.matroska.VoidElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaFileTracks {
    private static final int BLOCK_SIZE = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(MatroskaFileTracks.class);
    private final ArrayList<MatroskaFileTrack> tracks = new ArrayList();
    private final long myPosition;

    public MatroskaFileTracks(long position) {
        this.myPosition = position;
    }

    public void addTrack(MatroskaFileTrack track) {
        this.tracks.add(track);
    }

    public long writeTracks(DataWriter ioDW) {
        MasterElement tracksElem = MatroskaDocTypes.Tracks.getInstance();
        for (MatroskaFileTrack track : this.tracks) {
            tracksElem.addChildElement(track.toElement());
        }
        tracksElem.writeElement(ioDW);
        assert (4096L > tracksElem.getTotalSize());
        new VoidElement(4096L - tracksElem.getTotalSize()).writeElement(ioDW);
        return 4096L;
    }

    public void update(DataWriter ioDW) {
        LOG.info("Updating tracks list!");
        long start = ioDW.getFilePointer();
        ioDW.seek(this.myPosition);
        this.writeTracks(ioDW);
        ioDW.seek(start);
    }
}

