/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.ebml.EBMLReader;
import org.ebml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaBlock {
    private static final Logger LOG = LoggerFactory.getLogger(MatroskaBlock.class);
    protected int[] sizes = null;
    protected int headerSize = 0;
    protected int blockTimecode = 0;
    protected int trackNo = 0;
    private boolean keyFrame;
    private final ByteBuffer data;

    public MatroskaBlock(ByteBuffer data) {
        LOG.trace("Block created with data {}, {}", (Object)data.limit(), (Object)data.position());
        this.data = data;
    }

    public void parseBlock() {
        int index = 0;
        this.trackNo = (int)EBMLReader.readEBMLCode(this.data);
        index = Element.codedSizeLength(this.trackNo, 0);
        this.headerSize += index;
        this.blockTimecode = this.data.getShort();
        LOG.trace("Block belongs to track {} @ {}", (Object)this.trackNo, (Object)this.blockTimecode);
        byte flagsByte = this.data.get();
        int keyFlag = flagsByte & 0x80;
        this.keyFrame = keyFlag > 0;
        int laceFlag = flagsByte & 6;
        ++index;
        this.headerSize += 3;
        if (laceFlag != 0) {
            int laceCount = this.data.get();
            ++this.headerSize;
            if (laceFlag == 2) {
                LOG.trace("Reading xiph lace sizes");
                this.sizes = this.readXiphLaceSizes(index, (short)laceCount);
            } else if (laceFlag == 6) {
                LOG.trace("Reading ebml lace sizes");
                this.sizes = this.readEBMLLaceSizes(index, (short)laceCount);
            } else if (laceFlag == 4) {
                LOG.trace("Fixed lace sizes");
                this.sizes = new int[laceCount + 1];
                this.sizes[0] = (this.data.remaining() - this.headerSize) / (laceCount + 1);
                for (int s = 0; s < laceCount; ++s) {
                    this.sizes[s + 1] = this.sizes[0];
                }
            } else {
                throw new RuntimeException("Unsupported lacing type flag.");
            }
            LOG.trace("Lace sizes: {}", (Object)Arrays.toString(this.sizes));
        }
        this.headerSize = this.data.position();
    }

    private int[] readEBMLLaceSizes(int index, short laceCount) {
        int[] laceSizes = new int[laceCount + 1];
        laceSizes[laceCount] = this.data.remaining();
        int startIndex = index;
        laceSizes[0] = (int)EBMLReader.readEBMLCode(this.data);
        index += Element.codedSizeLength(laceSizes[0], 0);
        short s = laceCount;
        laceSizes[s] = laceSizes[s] - laceSizes[0];
        long firstEBMLSize = laceSizes[0];
        long lastEBMLSize = 0L;
        for (int l = 0; l < laceCount - 1; ++l) {
            lastEBMLSize = EBMLReader.readSignedEBMLCode(this.data);
            index += Element.codedSizeLength(lastEBMLSize, 0);
            laceSizes[l + 1] = (int)(firstEBMLSize += lastEBMLSize);
            short s2 = laceCount;
            laceSizes[s2] = laceSizes[s2] - laceSizes[l + 1];
        }
        this.headerSize = this.headerSize + index - startIndex;
        short s3 = laceCount;
        laceSizes[s3] = laceSizes[s3] - (index - startIndex);
        return laceSizes;
    }

    private int[] readXiphLaceSizes(int index, short laceCount) {
        int[] laceSizes = new int[laceCount + 1];
        laceSizes[laceCount] = this.data.remaining();
        for (int l = 0; l < laceCount; ++l) {
            int laceSizeByte = 255;
            while (laceSizeByte == 255) {
                laceSizeByte = (short)(this.data.get() & 0xFF);
                ++this.headerSize;
                int n = l;
                laceSizes[n] = laceSizes[n] + laceSizeByte;
            }
            int n = laceCount;
            laceSizes[n] = laceSizes[n] - laceSizes[l];
        }
        int n = laceCount;
        laceSizes[n] = laceSizes[n] - this.headerSize;
        return laceSizes;
    }

    public int getFrameCount() {
        if (this.sizes == null) {
            return 1;
        }
        return this.sizes.length;
    }

    public ByteBuffer getFrame(int frame) {
        int endOffset;
        int startOffset = this.headerSize;
        if (this.sizes == null) {
            if (frame != 0) {
                throw new IllegalArgumentException("Tried to read laced frame on non-laced Block. MatroskaBlock.getFrame(frame > 0)");
            }
            endOffset = this.headerSize + this.data.remaining();
        } else {
            for (int s = 0; s < frame; ++s) {
                startOffset += this.sizes[s];
            }
            endOffset = this.sizes[frame] + startOffset;
        }
        ByteBuffer frameData = this.data.duplicate();
        frameData.position(startOffset);
        frameData.limit(endOffset);
        return frameData;
    }

    public long getAdjustedBlockTimecode(long clusterTimecode, long timecodeScale) {
        return clusterTimecode + (long)this.blockTimecode;
    }

    public int getTrackNo() {
        return this.trackNo;
    }

    public int getBlockTimecode() {
        return this.blockTimecode;
    }

    public void setFrameData(short trackNo, int timecode, byte[] data) {
    }

    public boolean isKeyFrame() {
        return this.keyFrame;
    }
}

