/*
 * Decompiled with CFR 0.152.
 */
package org.ebml;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.ebml.EBMLReader;
import org.ebml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoType<T extends Element> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoType.class);
    private static final HashMap<Long, ProtoType<? extends Element>> CLASS_MAP = new HashMap();
    Class<T> clazz;
    private final ByteBuffer type;
    private final String name;
    private final int level;

    public ProtoType(Class<T> clazz, String name, byte[] type, int level) {
        this.clazz = clazz;
        this.type = ByteBuffer.wrap(type);
        this.name = name;
        this.level = level;
        long codename = EBMLReader.parseEBMLCode(this.type);
        CLASS_MAP.put(codename, this);
        LOG.trace("Associating {} with {}", (Object)name, (Object)codename);
    }

    public T getInstance() {
        LOG.trace("Instantiating {}", (Object)this.name);
        try {
            Element elem = (Element)this.clazz.newInstance();
            elem.setType(this.type);
            elem.setElementType(this);
            return (T)elem;
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("Failed to instantiate: this should never happen!", e);
            throw new RuntimeException(e);
        }
    }

    public static Element getInstance(ByteBuffer type) {
        long codename = EBMLReader.parseEBMLCode(type);
        ProtoType<? extends Element> eType = CLASS_MAP.get(codename);
        LOG.trace("Got codename {}, for element type {}", (Object)codename, (Object)eType.name);
        return eType.getInstance();
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public ByteBuffer getType() {
        return this.type;
    }
}

