/*
 * Decompiled with CFR 0.152.
 */
package org.ebml;

import java.nio.ByteBuffer;
import org.ebml.BinaryElement;

public class FloatElement
extends BinaryElement {
    public FloatElement(byte[] type) {
        super(type);
    }

    public FloatElement() {
    }

    public void setValue(double value) {
        if (value < 3.4028234663852886E38) {
            ByteBuffer buf = ByteBuffer.allocate(4);
            buf.putFloat((float)value);
            buf.flip();
            this.setData(buf);
        } else {
            ByteBuffer buf = ByteBuffer.allocate(4);
            buf.putDouble(value);
            buf.flip();
            this.setData(buf);
        }
    }

    public double getValue() {
        this.data.mark();
        try {
            if (this.size == 4L) {
                double d = this.data.getFloat();
                return d;
            }
            if (this.size == 8L) {
                double d = this.data.getDouble();
                return d;
            }
            throw new ArithmeticException("80-bit floats are not supported");
        }
        finally {
            this.data.reset();
        }
    }
}

