/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.Objects;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.SelfUserImpl;
import net.dv8tion.jda.core.events.self.SelfUpdateAvatarEvent;
import net.dv8tion.jda.core.events.self.SelfUpdateEmailEvent;
import net.dv8tion.jda.core.events.self.SelfUpdateMFAEvent;
import net.dv8tion.jda.core.events.self.SelfUpdateNameEvent;
import net.dv8tion.jda.core.events.self.SelfUpdateVerifiedEvent;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONObject;

public class UserUpdateHandler
extends SocketHandler {
    public UserUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String email;
        SelfUserImpl self = (SelfUserImpl)this.api.getSelfUser();
        String name = content.getString("username");
        String discriminator = content.getString("discriminator");
        String avatarId = !content.isNull("avatar") ? content.getString("avatar") : null;
        Boolean verified = content.has("verified") ? Boolean.valueOf(content.getBoolean("verified")) : null;
        Boolean mfaEnabled = content.has("mfa_enabled") ? Boolean.valueOf(content.getBoolean("mfa_enabled")) : null;
        String string = email = !content.isNull("email") ? content.getString("email") : null;
        if (!Objects.equals(name, self.getName()) || !Objects.equals(discriminator, self.getDiscriminator())) {
            String oldName = self.getName();
            String oldDiscriminator = self.getDiscriminator();
            self.setName(name);
            self.setDiscriminator(discriminator);
            this.api.getEventManager().handle(new SelfUpdateNameEvent(this.api, this.responseNumber, oldName, oldDiscriminator));
        }
        if (!Objects.equals(avatarId, self.getAvatarId())) {
            String oldAvatarId = self.getAvatarId();
            self.setAvatarId(avatarId);
            this.api.getEventManager().handle(new SelfUpdateAvatarEvent(this.api, this.responseNumber, oldAvatarId));
        }
        if (verified != null && verified.booleanValue() != self.isVerified()) {
            boolean wasVerified = self.isVerified();
            self.setVerified(verified);
            this.api.getEventManager().handle(new SelfUpdateVerifiedEvent(this.api, this.responseNumber, wasVerified));
        }
        if (mfaEnabled != null && mfaEnabled.booleanValue() != self.isMfaEnabled()) {
            boolean wasMfaEnabled = self.isMfaEnabled();
            self.setMfaEnabled(mfaEnabled);
            this.api.getEventManager().handle(new SelfUpdateMFAEvent(this.api, this.responseNumber, wasMfaEnabled));
        }
        if (this.api.getAccountType() == AccountType.CLIENT && !Objects.equals(email, self.getEmail())) {
            String oldEmail = self.getEmail();
            self.setEmail(email);
            this.api.getEventManager().handle(new SelfUpdateEmailEvent(this.api, this.responseNumber, oldEmail));
        }
        return null;
    }
}

