/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.GuildVoiceStateImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.core.events.guild.member.GuildMemberLeaveEvent;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceLeaveEvent;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.GuildLock;
import org.json.JSONObject;

public class GuildMemberRemoveHandler
extends SocketHandler {
    public GuildMemberRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"));
        if (guild == null) {
            return null;
        }
        String userId = content.getJSONObject("user").getString("id");
        MemberImpl member = (MemberImpl)guild.getMembersMap().remove(userId);
        if (member.getVoiceState().inVoiceChannel()) {
            GuildVoiceStateImpl vState = (GuildVoiceStateImpl)member.getVoiceState();
            VoiceChannel channel = vState.getChannel();
            vState.setConnectedChannel(null);
            ((VoiceChannelImpl)channel).getConnectedMembersMap().remove(member);
            this.api.getEventManager().handle(new GuildVoiceLeaveEvent(this.api, this.responseNumber, member, channel));
        }
        if (!(this.api.getGuildMap().values().stream().anyMatch(g -> ((GuildImpl)g).getMembersMap().containsKey(userId)) || this.api.getAccountType() == AccountType.CLIENT && this.api.asClient().getFriendById(userId) != null)) {
            UserImpl user = (UserImpl)this.api.getUserMap().remove(userId);
            if (user.hasPrivateChannel()) {
                PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                user.setFake(true);
                priv.setFake(true);
                this.api.getFakeUserMap().put(user.getId(), user);
                this.api.getFakePrivateChannelMap().put(priv.getId(), priv);
            } else if (this.api.getAccountType() == AccountType.CLIENT) {
                for (Group grp : this.api.asClient().getGroups()) {
                    if (!grp.getNonFriendUsers().contains(user)) continue;
                    user.setFake(true);
                    this.api.getFakeUserMap().put(user.getId(), user);
                    break;
                }
            }
        }
        this.api.getEventManager().handle(new GuildMemberLeaveEvent(this.api, this.responseNumber, guild, member));
        return null;
    }
}

