/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.managers.ChannelManager;
import net.dv8tion.jda.core.managers.ChannelManagerUpdatable;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.apache.http.util.Args;
import org.json.JSONObject;

public class VoiceChannelImpl
implements VoiceChannel {
    private final String id;
    private final GuildImpl guild;
    private final HashMap<Member, PermissionOverride> memberOverrides = new HashMap();
    private final HashMap<Role, PermissionOverride> roleOverrides = new HashMap();
    private final HashMap<String, Member> connectedMembers = new HashMap();
    private volatile ChannelManager manager;
    private volatile ChannelManagerUpdatable managerUpdatable;
    private Object mngLock = new Object();
    private String name;
    private int rawPosition;
    private int userLimit;
    private int bitrate;

    public VoiceChannelImpl(String id, Guild guild) {
        this.id = id;
        this.guild = (GuildImpl)guild;
    }

    @Override
    public int getUserLimit() {
        return this.userLimit;
    }

    @Override
    public int getBitrate() {
        return this.bitrate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public List<Member> getMembers() {
        return Collections.unmodifiableList(new ArrayList<Member>(this.connectedMembers.values()));
    }

    @Override
    public int getPosition() {
        List<VoiceChannel> channels = this.guild.getVoiceChannels();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Somehow when determining position we never found the VoiceChannel in the Guild's channels? wtf?");
    }

    @Override
    public int getPositionRaw() {
        return this.rawPosition;
    }

    @Override
    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @Override
    public PermissionOverride getPermissionOverride(Member member) {
        return this.memberOverrides.get(member);
    }

    @Override
    public PermissionOverride getPermissionOverride(Role role) {
        return this.roleOverrides.get(role);
    }

    @Override
    public List<PermissionOverride> getPermissionOverrides() {
        ArrayList<PermissionOverride> overrides = new ArrayList<PermissionOverride>(this.memberOverrides.size() + this.roleOverrides.size());
        overrides.addAll(this.memberOverrides.values());
        overrides.addAll(this.roleOverrides.values());
        return Collections.unmodifiableList(overrides);
    }

    @Override
    public List<PermissionOverride> getMemberPermissionOverrides() {
        return Collections.unmodifiableList(new ArrayList<PermissionOverride>(this.memberOverrides.values()));
    }

    @Override
    public List<PermissionOverride> getRolePermissionOverrides() {
        return Collections.unmodifiableList(new ArrayList<PermissionOverride>(this.roleOverrides.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelManager getManager() {
        ChannelManager mng = this.manager;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.manager;
                if (mng == null) {
                    mng = this.manager = new ChannelManager(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelManagerUpdatable getManagerUpdatable() {
        ChannelManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.managerUpdatable;
                if (mng == null) {
                    mng = this.managerUpdatable = new ChannelManagerUpdatable(this);
                }
            }
        }
        return mng;
    }

    @Override
    public RestAction<Void> delete() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Route.CompiledRoute route = Route.Channels.DELETE_CHANNEL.compile(this.id);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<PermissionOverride> createPermissionOverride(final Member member) {
        this.checkPermission(Permission.MANAGE_PERMISSIONS);
        Args.notNull(member, "member");
        if (!this.guild.equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided member is not from the same guild as this channel!");
        }
        if (this.getMemberOverrideMap().containsKey(member)) {
            throw new IllegalStateException("Provided member already has a PermissionOverride in this channel!");
        }
        final PermissionOverrideImpl override = new PermissionOverrideImpl(this, member, null);
        JSONObject body = new JSONObject().put("id", member.getUser().getId()).put("type", "member").put("allow", 0).put("deny", 0);
        Route.CompiledRoute route = Route.Channels.CREATE_PERM_OVERRIDE.compile(this.id, member.getUser().getId());
        return new RestAction<PermissionOverride>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                VoiceChannelImpl.this.getMemberOverrideMap().put(member, override);
                request.onSuccess(override);
            }
        };
    }

    @Override
    public RestAction<PermissionOverride> createPermissionOverride(final Role role) {
        this.checkPermission(Permission.MANAGE_PERMISSIONS);
        Args.notNull(role, "role");
        if (!this.guild.equals(role.getGuild())) {
            throw new IllegalArgumentException("Provided role is not from the same guild as this channel!");
        }
        if (this.getRoleOverrideMap().containsKey(role)) {
            throw new IllegalStateException("Provided role already has a PermissionOverride in this channel!");
        }
        final PermissionOverrideImpl override = new PermissionOverrideImpl(this, null, role);
        JSONObject body = new JSONObject().put("id", role.getId()).put("type", "role").put("allow", 0).put("deny", 0);
        Route.CompiledRoute route = Route.Channels.CREATE_PERM_OVERRIDE.compile(this.id, role.getId());
        return new RestAction<PermissionOverride>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                VoiceChannelImpl.this.getRoleOverrideMap().put(role, override);
                request.onSuccess(override);
            }
        };
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VoiceChannel)) {
            return false;
        }
        VoiceChannel oVChannel = (VoiceChannel)o;
        return this == oVChannel || this.getId().equals(oVChannel.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "VC:" + this.getName() + '(' + this.getId() + ')';
    }

    @Override
    public int compareTo(VoiceChannel chan) {
        if (this == chan) {
            return 0;
        }
        if (this.getGuild() != chan.getGuild()) {
            throw new IllegalArgumentException("Cannot compare VoiceChannels that aren't from the same guild!");
        }
        if (this.getPositionRaw() != chan.getPositionRaw()) {
            return chan.getPositionRaw() - this.getPositionRaw();
        }
        OffsetDateTime thisTime = this.getCreationTime();
        OffsetDateTime chanTime = chan.getCreationTime();
        return chanTime.compareTo(thisTime);
    }

    public VoiceChannelImpl setName(String name) {
        this.name = name;
        return this;
    }

    public VoiceChannelImpl setRawPosition(int rawPosition) {
        this.rawPosition = rawPosition;
        return this;
    }

    public VoiceChannelImpl setUserLimit(int userLimit) {
        this.userLimit = userLimit;
        return this;
    }

    public VoiceChannelImpl setBitrate(int bitrate) {
        this.bitrate = bitrate;
        return this;
    }

    public HashMap<Member, PermissionOverride> getMemberOverrideMap() {
        return this.memberOverrides;
    }

    public HashMap<Role, PermissionOverride> getRoleOverrideMap() {
        return this.roleOverrides;
    }

    public HashMap<String, Member> getConnectedMembersMap() {
        return this.connectedMembers;
    }

    private void checkPermission(Permission permission) {
        this.checkPermission(permission, null);
    }

    private void checkPermission(Permission permission, String message) {
        if (!this.guild.getSelfMember().hasPermission((Channel)this, permission)) {
            if (message != null) {
                throw new PermissionException(permission, message);
            }
            throw new PermissionException(permission);
        }
    }
}

